/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.auth;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.seata.common.util.ConfigTools;

public class RamSignAdapter {
    private static final String SHA256_ENCRYPT = "HmacSHA256";
    private static final String PREFIX = "aliyun_v4";
    private static final String CONSTANT = "aliyun_v4_request";
    private static final String DEFAULT_REGION = "cn-beijing";
    private static final String DEFAULT_PRODCUT_CODE = "seata";
    private static final DateTimeFormatter DTF = DateTimeFormatter.ofPattern("yyyyMMdd");

    private static byte[] getDateSigningKey(String secret, String date, String signMethod) {
        try {
            Mac mac = Mac.getInstance(signMethod);
            mac.init(new SecretKeySpec((PREFIX + secret).getBytes(StandardCharsets.UTF_8), signMethod));
            return mac.doFinal(date.getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("unsupport Algorithm:" + signMethod);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("InvalidKey");
        }
    }

    private static byte[] getRegionSigningKey(String secret, String date, String region, String signMethod) {
        byte[] dateSignkey = RamSignAdapter.getDateSigningKey(secret, date, signMethod);
        try {
            Mac mac = Mac.getInstance(signMethod);
            mac.init(new SecretKeySpec(dateSignkey, signMethod));
            return mac.doFinal(region.getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("unsupport Algorithm:" + signMethod);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("InvalidKey");
        }
    }

    private static byte[] getProductSigningKey(String secret, String date, String region, String productCode, String signMethod) {
        byte[] regionSignkey = RamSignAdapter.getRegionSigningKey(secret, date, region, signMethod);
        try {
            Mac mac = Mac.getInstance(signMethod);
            mac.init(new SecretKeySpec(regionSignkey, signMethod));
            byte[] thirdSigningKey = mac.doFinal(productCode.getBytes(StandardCharsets.UTF_8));
            mac = Mac.getInstance(signMethod);
            mac.init(new SecretKeySpec(thirdSigningKey, signMethod));
            return mac.doFinal(CONSTANT.getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("unsupport Algorithm:" + signMethod);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("InvalidKey");
        }
    }

    public static String getRamSign(String encryptText, String encryptKey) {
        try {
            String[] encryptData = encryptText.split(",");
            byte[] data = RamSignAdapter.getProductSigningKey(encryptKey, LocalDateTime.ofEpochSecond(Long.parseLong(encryptData[2]) / 1000L, 0, ZoneOffset.UTC).format(DTF), DEFAULT_REGION, DEFAULT_PRODCUT_CODE, SHA256_ENCRYPT);
            SecretKeySpec secretKey = new SecretKeySpec(data, SHA256_ENCRYPT);
            Mac mac = Mac.getInstance(SHA256_ENCRYPT);
            mac.init(secretKey);
            byte[] text = encryptText.getBytes(StandardCharsets.UTF_8);
            byte[] textFinal = mac.doFinal(text);
            return ConfigTools.byte2Base64(textFinal);
        }
        catch (Exception e) {
            throw new RuntimeException("get ram sign with hmacSHA1Encrypt fail", e);
        }
    }
}

