/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.config.zk;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.CuratorCache;
import org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.curator.retry.RetryNTimes;
import org.apache.seata.common.exception.NotSupportYetException;
import org.apache.seata.common.thread.NamedThreadFactory;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.AbstractConfiguration;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationChangeEvent;
import org.apache.seata.config.ConfigurationChangeListener;
import org.apache.seata.config.ConfigurationChangeType;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.config.processor.ConfigProcessor;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperConfiguration
extends AbstractConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperConfiguration.class);
    private static final String CONFIG_TYPE = "zk";
    private static final String ZK_PATH_SPLIT_CHAR = "/";
    private static final String ROOT_PATH = "/seata";
    private static final Configuration FILE_CONFIG = ConfigurationFactory.CURRENT_FILE_INSTANCE;
    private static final String SERVER_ADDR_KEY = "serverAddr";
    private static final String SESSION_TIMEOUT_KEY = "sessionTimeout";
    private static final String CONNECT_TIMEOUT_KEY = "connectTimeout";
    private static final String AUTH_USERNAME = "username";
    private static final String AUTH_PASSWORD = "password";
    private static final String SERIALIZER_KEY = "serializer";
    private static final String CONFIG_PATH_KEY = "nodePath";
    private static final int THREAD_POOL_NUM = 1;
    private static final int DEFAULT_SESSION_TIMEOUT = 6000;
    private static final int DEFAULT_CONNECT_TIMEOUT = 2000;
    private static final String DEFAULT_CONFIG_PATH = "/seata/seata.properties";
    private static final String FILE_CONFIG_KEY_PREFIX = "config.zk.";
    private static final ExecutorService CONFIG_EXECUTOR = new ThreadPoolExecutor(1, 1, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("ZKConfigThread", 1));
    private static volatile CuratorFramework zkClient;
    private static final int MAP_INITIAL_CAPACITY = 8;
    private static final ConcurrentMap<String, ConcurrentMap<ConfigurationChangeListener, NodeCacheListenerImpl>> CONFIG_LISTENERS_MAP;
    private static volatile Properties seataConfig;
    static final Charset CHARSET;
    private static Map<String, CuratorCache> nodeCacheMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ZookeeperConfiguration() {
        if (zkClient != null) return;
        Class<ZookeeperConfiguration> clazz = ZookeeperConfiguration.class;
        synchronized (ZookeeperConfiguration.class) {
            if (zkClient == null) {
                String serverAddr = FILE_CONFIG.getConfig("config.zk.serverAddr");
                int sessionTimeout = FILE_CONFIG.getInt("config.zk.sessionTimeout", 6000);
                int connectTimeout = FILE_CONFIG.getInt("config.zk.connectTimeout", 2000);
                CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(serverAddr).retryPolicy((RetryPolicy)new RetryNTimes(1, 1000)).connectionTimeoutMs(connectTimeout).sessionTimeoutMs(sessionTimeout);
                String username = FILE_CONFIG.getConfig("config.zk.username");
                String password = FILE_CONFIG.getConfig("config.zk.password");
                if (!StringUtils.isBlank(username) && !StringUtils.isBlank(password)) {
                    StringBuilder auth = new StringBuilder(username).append(":").append(password);
                    builder.authorization("digest", auth.toString().getBytes());
                }
                zkClient = builder.build();
                zkClient.start();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (!this.checkExists(ROOT_PATH)) {
                this.createPersistent(ROOT_PATH);
            }
            this.initSeataConfig();
            return;
        }
    }

    public void createPersistent(String path) {
        try {
            zkClient.create().forPath(path);
        }
        catch (KeeperException.NodeExistsException e) {
            LOGGER.warn("ZNode " + path + " already exists.", (Throwable)e);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public boolean checkExists(String path) {
        try {
            if (zkClient.checkExists().forPath(path) != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public String getTypeName() {
        return CONFIG_TYPE;
    }

    @Override
    public String getLatestConfig(String dataId, String defaultValue, long timeoutMills) {
        String value = seataConfig.getProperty(dataId);
        if (value != null) {
            return value;
        }
        FutureTask<String> future = new FutureTask<String>(() -> {
            String path = this.buildPath(dataId);
            if (!this.checkExists(path)) {
                LOGGER.warn("config {} is not existed, return defaultValue {} ", (Object)dataId, (Object)defaultValue);
                return defaultValue;
            }
            String value1 = this.readData(path);
            return StringUtils.isNullOrEmpty(value1) ? defaultValue : value1;
        });
        CONFIG_EXECUTOR.execute(future);
        try {
            return future.get(timeoutMills, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            LOGGER.error("getConfig {} error or timeout, return defaultValue {}, exception:{} ", new Object[]{dataId, defaultValue, e.getMessage()});
            return defaultValue;
        }
    }

    public String readData(String path) {
        try {
            byte[] dataBytes = (byte[])zkClient.getData().forPath(path);
            return dataBytes == null || dataBytes.length == 0 ? null : new String(dataBytes, CHARSET);
        }
        catch (KeeperException.NoNodeException dataBytes) {
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return null;
    }

    @Override
    public boolean putConfig(String dataId, String content, long timeoutMills) {
        if (!seataConfig.isEmpty()) {
            seataConfig.setProperty(dataId, content);
            this.createPersistent(ZookeeperConfiguration.getConfigPath(), ZookeeperConfiguration.getSeataConfigStr());
            return true;
        }
        FutureTask<Boolean> future = new FutureTask<Boolean>(() -> {
            String path = this.buildPath(dataId);
            if (!this.checkExists(path)) {
                this.createPersistent(path, content);
            } else {
                this.createPersistent(path, content);
            }
            return true;
        });
        CONFIG_EXECUTOR.execute(future);
        try {
            return future.get(timeoutMills, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            LOGGER.error("putConfig {}, value: {} is error or timeout, exception: {}", new Object[]{dataId, content, e.getMessage()});
            return false;
        }
    }

    public String buildPath(String dataId) {
        String path = "/seata/" + dataId;
        return path;
    }

    protected void createPersistent(String path, String data) {
        byte[] dataBytes = data.getBytes(CHARSET);
        try {
            zkClient.create().forPath(path, dataBytes);
        }
        catch (KeeperException.NodeExistsException e) {
            try {
                zkClient.setData().forPath(path, dataBytes);
            }
            catch (Exception e1) {
                throw new IllegalStateException(e.getMessage(), e1);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public boolean putConfigIfAbsent(String dataId, String content, long timeoutMills) {
        throw new NotSupportYetException("not support atomic operation putConfigIfAbsent");
    }

    @Override
    public boolean removeConfig(String dataId, long timeoutMills) {
        if (!seataConfig.isEmpty()) {
            seataConfig.remove(dataId);
            this.createPersistent(ZookeeperConfiguration.getConfigPath(), ZookeeperConfiguration.getSeataConfigStr());
            return true;
        }
        FutureTask<Boolean> future = new FutureTask<Boolean>(() -> {
            String path = this.buildPath(dataId);
            return this.deletePath(path);
        });
        CONFIG_EXECUTOR.execute(future);
        try {
            return future.get(timeoutMills, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            LOGGER.error("removeConfig {} is error or timeout, exception:{}", (Object)dataId, (Object)e.getMessage());
            return false;
        }
    }

    protected boolean deletePath(String path) {
        try {
            zkClient.delete().deletingChildrenIfNeeded().forPath(path);
            return true;
        }
        catch (KeeperException.NoNodeException ignored) {
            return true;
        }
        catch (Exception e) {
            LOGGER.error("deletePath {} is error or timeout", (Object)path, (Object)e);
            return false;
        }
    }

    @Override
    public void addConfigListener(String dataId, ConfigurationChangeListener listener) {
        if (StringUtils.isBlank(dataId) || listener == null) {
            return;
        }
        String path = this.buildPath(dataId);
        if (!seataConfig.isEmpty()) {
            NodeCacheListenerImpl zkListener = new NodeCacheListenerImpl(dataId, listener);
            CuratorCacheListener.builder().forAll((CuratorCacheListener)zkListener).build();
            CONFIG_LISTENERS_MAP.computeIfAbsent(dataId, key -> new ConcurrentHashMap()).put(listener, zkListener);
            return;
        }
        if (this.checkExists(path)) {
            NodeCacheListenerImpl zkListener = new NodeCacheListenerImpl(path, listener);
            CONFIG_LISTENERS_MAP.computeIfAbsent(dataId, key -> new ConcurrentHashMap()).put(listener, zkListener);
            this.addDataListener(path, zkListener);
        }
    }

    @Override
    public void removeConfigListener(String dataId, ConfigurationChangeListener listener) {
        String path;
        if (StringUtils.isBlank(dataId) || listener == null) {
            return;
        }
        Set<ConfigurationChangeListener> configChangeListeners = this.getConfigListeners(dataId);
        if (CollectionUtils.isNotEmpty(configChangeListeners) && this.checkExists(path = this.buildPath(dataId))) {
            for (ConfigurationChangeListener entry : configChangeListeners) {
                if (!listener.equals(entry)) continue;
                NodeCacheListenerImpl zkListener = null;
                Map configListeners = (Map)CONFIG_LISTENERS_MAP.get(dataId);
                if (configListeners != null) {
                    zkListener = (NodeCacheListenerImpl)configListeners.get(listener);
                    configListeners.remove(entry);
                }
                if (zkListener == null) break;
                this.removeDataListener(path, zkListener);
                break;
            }
        }
    }

    @Override
    public Set<ConfigurationChangeListener> getConfigListeners(String dataId) {
        ConcurrentMap configListeners = (ConcurrentMap)CONFIG_LISTENERS_MAP.get(dataId);
        if (CollectionUtils.isNotEmpty(configListeners)) {
            return configListeners.keySet();
        }
        return null;
    }

    private void initSeataConfig() {
        String configPath = ZookeeperConfiguration.getConfigPath();
        String config = this.readData(configPath);
        if (StringUtils.isNotBlank(config)) {
            try {
                seataConfig = ConfigProcessor.processConfig(config, ZookeeperConfiguration.getZkDataType());
            }
            catch (IOException e) {
                LOGGER.error("init config properties error", (Throwable)e);
            }
            this.addDataListener(configPath, new NodeCacheListenerImpl(configPath, null));
        }
    }

    private static String getConfigPath() {
        return FILE_CONFIG.getConfig("config.zk.nodePath", DEFAULT_CONFIG_PATH);
    }

    private static String getZkDataType() {
        return ConfigProcessor.resolverConfigDataType(ZookeeperConfiguration.getConfigPath());
    }

    private static String getSeataConfigStr() {
        StringBuilder sb = new StringBuilder();
        Enumeration<?> enumeration = seataConfig.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String property = seataConfig.getProperty(key);
            sb.append(key).append("=").append(property).append("\n");
        }
        return sb.toString();
    }

    protected void addDataListener(String path, NodeCacheListenerImpl nodeCacheListener) {
        try {
            CuratorCache nodeCache = CuratorCache.build((CuratorFramework)zkClient, (String)path, (CuratorCache.Options[])new CuratorCache.Options[0]);
            if (nodeCacheMap.putIfAbsent(path, nodeCache) != null) {
                return;
            }
            nodeCache.listenable().addListener((Object)nodeCacheListener);
            nodeCache.start();
        }
        catch (Exception e) {
            throw new IllegalStateException("Add nodeCache listener for path:" + path, e);
        }
    }

    protected void removeDataListener(String path, NodeCacheListenerImpl nodeCacheListener) {
        CuratorCache nodeCache = nodeCacheMap.get(path);
        if (nodeCache != null) {
            nodeCache.listenable().removeListener((Object)nodeCacheListener);
        }
        nodeCacheListener.listener = null;
    }

    static {
        CONFIG_LISTENERS_MAP = new ConcurrentHashMap<String, ConcurrentMap<ConfigurationChangeListener, NodeCacheListenerImpl>>(8);
        seataConfig = new Properties();
        CHARSET = StandardCharsets.UTF_8;
        nodeCacheMap = new ConcurrentHashMap<String, CuratorCache>();
    }

    public static class NodeCacheListenerImpl
    implements CuratorCacheListener {
        private String path;
        private ConfigurationChangeListener listener;

        public NodeCacheListenerImpl(String path, ConfigurationChangeListener listener) {
            this.path = path;
            this.listener = listener;
        }

        public void event(CuratorCacheListener.Type type, ChildData oldData, ChildData data) {
            String o = type == CuratorCacheListener.Type.NODE_DELETED ? "" : new String(data.getData());
            if (this.path.equals(ZookeeperConfiguration.getConfigPath())) {
                Properties seataConfigNew = new Properties();
                if (StringUtils.isNotBlank(o.toString())) {
                    try {
                        seataConfigNew = ConfigProcessor.processConfig(o.toString(), ZookeeperConfiguration.getZkDataType());
                    }
                    catch (IOException e) {
                        LOGGER.error("load config properties error", (Throwable)e);
                        return;
                    }
                }
                for (Map.Entry entry : CONFIG_LISTENERS_MAP.entrySet()) {
                    String propertyNew;
                    String listenedDataId = (String)entry.getKey();
                    String propertyOld = seataConfig.getProperty(listenedDataId, "");
                    if (propertyOld.equals(propertyNew = seataConfigNew.getProperty(listenedDataId, ""))) continue;
                    ConfigurationChangeEvent event = new ConfigurationChangeEvent().setDataId(listenedDataId).setNewValue(propertyNew).setChangeType(ConfigurationChangeType.MODIFY);
                    ConcurrentMap configListeners = (ConcurrentMap)entry.getValue();
                    for (ConfigurationChangeListener configListener : configListeners.keySet()) {
                        configListener.onProcessEvent(event);
                    }
                }
                seataConfig = seataConfigNew;
                return;
            }
            if (type == CuratorCacheListener.Type.NODE_DELETED) {
                String dataId = this.path.replaceFirst("/seata/", "");
                ConfigurationChangeEvent event = new ConfigurationChangeEvent().setDataId(dataId).setChangeType(ConfigurationChangeType.DELETE);
                this.listener.onProcessEvent(event);
            } else {
                String dataId = this.path.replaceFirst("/seata/", "");
                ConfigurationChangeEvent event = new ConfigurationChangeEvent().setDataId(dataId).setNewValue(o.toString()).setChangeType(ConfigurationChangeType.MODIFY);
                this.listener.onProcessEvent(event);
            }
        }
    }
}

