/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.awt.RenderingHints;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.Sides;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.interactive.viewerpreferences.PDViewerPreferences;
import org.apache.pdfbox.printing.Orientation;
import org.apache.pdfbox.printing.PDFPageable;

public final class PrintPDF {
    private static final String PASSWORD = "-password";
    private static final String SILENT = "-silentPrint";
    private static final String PRINTER_NAME = "-printerName";
    private static final String ORIENTATION = "-orientation";
    private static final String BORDER = "-border";
    private static final String DPI = "-dpi";
    private static final String NOCENTER = "-noCenter";
    private static final String NOCOLOROPT = "-noColorOpt";
    private static final String DUPLEX = "-duplex";
    private static final String TRAY = "-tray";
    private static final String MEDIA_SIZE = "-mediaSize";

    private PrintPDF() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws PrinterException, IOException {
        System.setProperty("apple.awt.UIElement", "true");
        String password = "";
        String pdfFile = null;
        boolean silentPrint = false;
        String printerName = null;
        Orientation orientation = Orientation.AUTO;
        boolean showPageBorder = false;
        int dpi = 0;
        boolean noCenter = false;
        HashMap<String, Orientation> orientationMap = new HashMap<String, Orientation>();
        orientationMap.put("auto", Orientation.AUTO);
        orientationMap.put("landscape", Orientation.LANDSCAPE);
        orientationMap.put("portrait", Orientation.PORTRAIT);
        RenderingHints renderingHints = null;
        String duplex = null;
        String tray = null;
        String mediaSize = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(PASSWORD)) {
                if (++i >= args.length) {
                    PrintPDF.usage();
                }
                password = args[i];
                continue;
            }
            if (args[i].equals(PRINTER_NAME)) {
                if (++i >= args.length) {
                    PrintPDF.usage();
                }
                printerName = args[i];
                continue;
            }
            if (args[i].equals(DUPLEX)) {
                if (++i >= args.length) {
                    PrintPDF.usage();
                }
                duplex = args[i];
                continue;
            }
            if (args[i].equals(TRAY)) {
                if (++i >= args.length) {
                    PrintPDF.usage();
                }
                tray = args[i];
                continue;
            }
            if (args[i].equals(MEDIA_SIZE)) {
                if (++i >= args.length) {
                    PrintPDF.usage();
                }
                mediaSize = args[i];
                continue;
            }
            if (args[i].equals(SILENT)) {
                silentPrint = true;
                continue;
            }
            if (args[i].equals(NOCENTER)) {
                noCenter = true;
                continue;
            }
            if (args[i].equals(ORIENTATION)) {
                if (++i >= args.length) {
                    PrintPDF.usage();
                }
                if ((orientation = (Orientation)orientationMap.get(args[i])) != null) continue;
                PrintPDF.usage();
                continue;
            }
            if (args[i].equals(BORDER)) {
                showPageBorder = true;
                continue;
            }
            if (args[i].equals(NOCOLOROPT)) {
                renderingHints = new RenderingHints(null);
                renderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                continue;
            }
            if (args[i].equals(DPI)) {
                if (++i >= args.length) {
                    PrintPDF.usage();
                }
                dpi = Integer.parseInt(args[i]);
                continue;
            }
            pdfFile = args[i];
        }
        if (pdfFile == null) {
            PrintPDF.usage();
        }
        PDDocument document = null;
        try {
            document = PDDocument.load((File)new File(pdfFile), (String)password);
            AccessPermission ap = document.getCurrentAccessPermission();
            if (!ap.canPrint()) {
                throw new IOException("You do not have permission to print");
            }
            PrinterJob printJob = PrinterJob.getPrinterJob();
            printJob.setJobName(new File(pdfFile).getName());
            if (printerName != null) {
                PrintService[] printServices = PrinterJob.lookupPrintServices();
                boolean printerFound = false;
                for (PrintService printService : printServices) {
                    if (!printService.getName().equalsIgnoreCase(printerName)) continue;
                    printJob.setPrintService(printService);
                    printerFound = true;
                    break;
                }
                if (!printerFound) {
                    System.err.println("printer '" + printerName + "' not found, using default '" + printJob.getPrintService().getName() + "'");
                    PrintPDF.showAvailablePrinters();
                }
            }
            PrintService printService = printJob.getPrintService();
            PrintRequestAttributeSet pras = PrintPDF.createPrintRequestAttributeSet(document, duplex);
            if (tray != null) {
                boolean found = false;
                for (Media media : PrintPDF.getTraysFromPrintService(printService)) {
                    if (!tray.equals(media.toString())) continue;
                    pras.add(media);
                    found = true;
                    break;
                }
                if (!found) {
                    System.err.println("Tray '" + tray + "' not supported, ignored. Valid values: " + PrintPDF.getTraysFromPrintService(printService));
                }
            }
            if (mediaSize != null) {
                boolean found = false;
                for (Media media : PrintPDF.getMediaSizesFromPrintService(printService)) {
                    if (!mediaSize.equals(media.toString())) continue;
                    pras.add(media);
                    found = true;
                    break;
                }
                if (!found) {
                    System.err.println("media size '" + mediaSize + "' not supported, ignored. Valid values: " + PrintPDF.getMediaSizesFromPrintService(printService));
                }
            }
            PDFPageable pageable = new PDFPageable(document, orientation, showPageBorder, (float)dpi, !noCenter);
            pageable.setRenderingHints(renderingHints);
            printJob.setPageable((Pageable)pageable);
            if (silentPrint || printJob.printDialog(pras)) {
                printJob.print(pras);
            }
        }
        finally {
            if (document != null) {
                document.close();
            }
        }
    }

    private static List<Media> getTraysFromPrintService(PrintService printService) {
        Media[] medias = (Media[])printService.getSupportedAttributeValues(Media.class, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        if (medias == null) {
            return Collections.emptyList();
        }
        ArrayList<Media> trayList = new ArrayList<Media>();
        for (Media media : medias) {
            if (!(media instanceof MediaTray)) continue;
            trayList.add(media);
        }
        return trayList;
    }

    private static List<Media> getMediaSizesFromPrintService(PrintService printService) {
        Media[] medias = (Media[])printService.getSupportedAttributeValues(Media.class, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        if (medias == null) {
            return Collections.emptyList();
        }
        ArrayList<Media> sizeList = new ArrayList<Media>();
        for (Media media : medias) {
            if (!(media instanceof MediaSizeName)) continue;
            sizeList.add(media);
        }
        return sizeList;
    }

    private static PrintRequestAttributeSet createPrintRequestAttributeSet(PDDocument document, String duplex) {
        HashPrintRequestAttributeSet pras = new HashPrintRequestAttributeSet();
        if (duplex == null || "document".equalsIgnoreCase(duplex)) {
            PDViewerPreferences vp = document.getDocumentCatalog().getViewerPreferences();
            if (vp != null && vp.getDuplex() != null) {
                String dp = vp.getDuplex();
                if (PDViewerPreferences.DUPLEX.DuplexFlipLongEdge.toString().equals(dp)) {
                    pras.add(Sides.TWO_SIDED_LONG_EDGE);
                } else if (PDViewerPreferences.DUPLEX.DuplexFlipShortEdge.toString().equals(dp)) {
                    pras.add(Sides.TWO_SIDED_SHORT_EDGE);
                } else if (PDViewerPreferences.DUPLEX.Simplex.toString().equals(dp)) {
                    pras.add(Sides.ONE_SIDED);
                }
            }
        } else if (duplex.equalsIgnoreCase("duplex")) {
            pras.add(Sides.DUPLEX);
        } else if (duplex.equalsIgnoreCase("tumble")) {
            pras.add(Sides.TUMBLE);
        } else if (duplex.equalsIgnoreCase("simplex")) {
            pras.add(Sides.ONE_SIDED);
        } else {
            System.out.println("duplex setting '" + duplex + "' is ignored");
        }
        return pras;
    }

    private static void usage() {
        String message = "Usage: java -jar pdfbox-app-x.y.z.jar PrintPDF [options] <inputfile>\n\nOptions:\n  -password  <password>                : Password to decrypt document\n  -printerName <name>                  : Print to specific printer\n  -orientation auto|portrait|landscape : Print using orientation\n                                           (default: auto)\n  -border                              : Print with border\n  -dpi                                 : Render into intermediate image with\n                                           specific dpi and then print.\n                                           Use \"-1\" for the dpi of the printer\n  -noCenter                            : align top-left\n                                       :   (default: center on page)\n  -noColorOpt                          : Disable color optimizations\n                                           (useful when printing barcodes)\n  -duplex SIMPLEX|DUPLEX|TUMBLE|DOCUMENT : Print using duplex (default: DOCUMENT)\n  -tray <tray>                         : Print using tray\n  -mediaSize <mediaSize>               : Print using media size name\n  -silentPrint                         : Print without printer dialog box\n";
        System.err.println(message);
        PrintPDF.showAvailablePrinters();
        System.exit(1);
    }

    private static void showAvailablePrinters() {
        PrintService[] printServices;
        System.err.println("Available printer names:");
        for (PrintService printService : printServices = PrinterJob.lookupPrintServices()) {
            System.err.println("    " + printService.getName());
            System.err.println("        Sizes: " + PrintPDF.getMediaSizesFromPrintService(printService));
            System.err.println("        Trays: " + PrintPDF.getTraysFromPrintService(printService));
        }
    }
}

