/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.ad;

import java.nio.charset.Charset;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.commons.Internal;
import opennlp.tools.formats.LanguageSampleStreamFactory;
import opennlp.tools.formats.ad.ADPOSSampleStream;
import opennlp.tools.postag.POSSample;
import opennlp.tools.util.ObjectStream;

@Internal
public class ADPOSSampleStreamFactory
extends LanguageSampleStreamFactory<POSSample, Parameters> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(POSSample.class, "ad", new ADPOSSampleStreamFactory(Parameters.class));
    }

    protected ADPOSSampleStreamFactory(Class<Parameters> params) {
        super(params);
    }

    @Override
    public ObjectStream<POSSample> create(String[] args) {
        Parameters params = this.validateBasicFormatParameters(args, Parameters.class);
        this.language = params.getLang();
        ObjectStream<String> lineStream = this.readData(args, Parameters.class);
        return new ADPOSSampleStream(lineStream, params.getExpandME(), params.getIncludeFeatures());
    }

    public static interface Parameters
    extends BasicFormatParams {
        @Override
        @ArgumentParser.ParameterDescription(valueName="charsetName", description="encoding for reading and writing text, if absent the system default is used.")
        public Charset getEncoding();

        @ArgumentParser.ParameterDescription(valueName="language", description="language which is being processed.")
        public String getLang();

        @ArgumentParser.ParameterDescription(valueName="expandME", description="expand multiword expressions.")
        @ArgumentParser.OptionalParameter(defaultValue="false")
        public Boolean getExpandME();

        @ArgumentParser.ParameterDescription(valueName="includeFeatures", description="combine POS Tags with word features, like number and gender.")
        @ArgumentParser.OptionalParameter(defaultValue="false")
        public Boolean getIncludeFeatures();
    }
}

