/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.providerapi;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.surefire.api.provider.SurefireProvider;
import org.apache.maven.surefire.providerapi.ConfigurableProviderInfo;
import org.apache.maven.surefire.providerapi.ProviderInfo;
import org.apache.maven.surefire.providerapi.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public final class ProviderDetector {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private ServiceLoader serviceLoader;

    @Nonnull
    public List<ProviderInfo> resolve(ConfigurableProviderInfo dynamicProvider, ProviderInfo ... wellKnownProviders) {
        Set<String> manuallyConfiguredProviders = this.getManuallyConfiguredProviders();
        List<ProviderInfo> providersToRun = manuallyConfiguredProviders.stream().map(name -> this.findByName((String)name, wellKnownProviders).orElseGet(() -> dynamicProvider.instantiate((String)name))).collect(Collectors.toList());
        providersToRun.forEach(p -> this.logger.info("Using configured provider " + p.getProviderName()));
        if (providersToRun.isEmpty()) {
            return this.autoDetectOneWellKnownProvider(wellKnownProviders).map(Collections::singletonList).orElse(Collections.emptyList());
        }
        return Collections.unmodifiableList(providersToRun);
    }

    private Optional<ProviderInfo> autoDetectOneWellKnownProvider(ProviderInfo ... wellKnownProviders) {
        Optional<ProviderInfo> providerInfo = Arrays.stream(wellKnownProviders).filter(ProviderInfo::isApplicable).findFirst();
        providerInfo.ifPresent(p -> this.logger.info("Using auto detected provider " + p.getProviderName()));
        return providerInfo;
    }

    private Set<String> getManuallyConfiguredProviders() {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            return this.serviceLoader.lookup(SurefireProvider.class, cl);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    private Optional<ProviderInfo> findByName(String providerClassName, ProviderInfo ... wellKnownProviders) {
        return Arrays.stream(wellKnownProviders).filter(p -> p.getProviderName().equals(providerClassName)).findFirst();
    }
}

