/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.com.caucho.hessian.io.java8;

import com.alibaba.com.caucho.hessian.io.AbstractDeserializer;
import com.alibaba.com.caucho.hessian.io.AbstractHessianInput;
import com.alibaba.com.caucho.hessian.io.IOExceptionWrapper;
import java.io.IOException;
import java.time.DayOfWeek;
import java.time.temporal.WeekFields;

public class WeekFieldsDeserializer
extends AbstractDeserializer {
    @Override
    public Class<?> getType() {
        return WeekFields.class;
    }

    @Override
    public Object readObject(AbstractHessianInput in, Object[] fields) throws IOException {
        try {
            return this.readObject(in, (String[])fields);
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOExceptionWrapper("java.net.Inet6Address:" + e, e);
        }
    }

    @Override
    public Object readObject(AbstractHessianInput in, String[] fieldNames) throws IOException {
        try {
            DayOfWeek firstDayOfWeek = null;
            int minimalDays = 0;
            for (String fieldName : fieldNames) {
                if ("firstDayOfWeek".equals(fieldName)) {
                    firstDayOfWeek = (DayOfWeek)in.readObject();
                    continue;
                }
                if ("minimalDays".equals(fieldName)) {
                    minimalDays = in.readInt();
                    continue;
                }
                in.readObject();
            }
            WeekFields obj = WeekFields.of(firstDayOfWeek, minimalDays);
            in.addRef(obj);
            return obj;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOExceptionWrapper("java.net.Inet6Address:" + e, e);
        }
    }
}

