/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.com.caucho.hessian.io;

import com.alibaba.com.caucho.hessian.io.AbstractDeserializer;
import com.alibaba.com.caucho.hessian.io.AbstractHessianInput;
import com.alibaba.com.caucho.hessian.io.IOExceptionWrapper;
import java.io.IOException;
import java.util.Currency;

public class CurrencyDeserializer
extends AbstractDeserializer {
    @Override
    public Class<?> getType() {
        return Currency.class;
    }

    @Override
    public Object readObject(AbstractHessianInput in, Object[] fields) throws IOException {
        try {
            return this.readObject(in, (String[])fields);
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOExceptionWrapper(Currency.class.getName() + ":" + e, e);
        }
    }

    @Override
    public Object readObject(AbstractHessianInput in, String[] fieldNames) throws IOException {
        try {
            String currencyCode = null;
            for (String fieldName : fieldNames) {
                if ("currencyCode".equals(fieldName)) {
                    currencyCode = in.readString();
                    continue;
                }
                in.readObject();
            }
            Currency obj = Currency.getInstance(currencyCode);
            in.addRef(obj);
            return obj;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOExceptionWrapper(Currency.class.getName() + ":" + e, e);
        }
    }
}

