/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.threadpool.serial;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadlocal.InternalThreadLocalMap;
import org.apache.dubbo.common.utils.ExecutorUtil;

public final class SerializingExecutor
implements Executor,
Runnable {
    private static final ErrorTypeAwareLogger LOGGER = LoggerFactory.getErrorTypeAwareLogger(SerializingExecutor.class);
    private final AtomicBoolean atomicBoolean = new AtomicBoolean();
    private final Executor executor;
    private final Queue<Runnable> runQueue = new ConcurrentLinkedQueue<Runnable>();

    public SerializingExecutor(Executor executor) {
        this.executor = executor;
    }

    @Override
    public void execute(Runnable r) {
        this.runQueue.add(r);
        this.schedule(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedule(Runnable removable) {
        if (this.atomicBoolean.compareAndSet(false, true)) {
            boolean success = false;
            try {
                if (!ExecutorUtil.isShutdown(this.executor)) {
                    this.executor.execute(this);
                    success = true;
                }
            }
            catch (RejectedExecutionException e) {
                if (!ExecutorUtil.isShutdown(this.executor)) {
                    throw e;
                }
            }
            finally {
                if (!success) {
                    if (removable != null) {
                        this.runQueue.remove(removable);
                    }
                    this.atomicBoolean.set(false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Runnable r;
            while ((r = this.runQueue.poll()) != null) {
                InternalThreadLocalMap internalThreadLocalMap = InternalThreadLocalMap.getAndRemove();
                try {
                    r.run();
                }
                catch (RuntimeException e) {
                    LOGGER.error("0-19", "", "", "Exception while executing runnable " + r, e);
                }
                finally {
                    InternalThreadLocalMap.set(internalThreadLocalMap);
                }
            }
        }
        finally {
            this.atomicBoolean.set(false);
        }
        if (!this.runQueue.isEmpty()) {
            this.schedule(null);
        }
    }
}

