/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.store.support;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.store.DataStore;
import org.apache.dubbo.common.store.DataStoreUpdateListener;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.common.utils.ConcurrentHashSet;

public class SimpleDataStore
implements DataStore {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(SimpleDataStore.class);
    private final ConcurrentMap<String, ConcurrentMap<String, Object>> data = new ConcurrentHashMap<String, ConcurrentMap<String, Object>>();
    private final ConcurrentHashSet<DataStoreUpdateListener> listeners = new ConcurrentHashSet();

    @Override
    public Map<String, Object> get(String componentName) {
        ConcurrentMap value = (ConcurrentMap)this.data.get(componentName);
        if (value == null) {
            return new HashMap<String, Object>();
        }
        return new HashMap<String, Object>(value);
    }

    @Override
    public Object get(String componentName, String key) {
        if (!this.data.containsKey(componentName)) {
            return null;
        }
        return ((ConcurrentMap)this.data.get(componentName)).get(key);
    }

    @Override
    public void put(String componentName, String key, Object value) {
        Map componentData = ConcurrentHashMapUtils.computeIfAbsent(this.data, componentName, k -> new ConcurrentHashMap());
        componentData.put(key, value);
        this.notifyListeners(componentName, key, value);
    }

    @Override
    public void remove(String componentName, String key) {
        if (!this.data.containsKey(componentName)) {
            return;
        }
        ((ConcurrentMap)this.data.get(componentName)).remove(key);
        this.notifyListeners(componentName, key, null);
    }

    @Override
    public void addListener(DataStoreUpdateListener dataStoreUpdateListener) {
        this.listeners.add(dataStoreUpdateListener);
    }

    private void notifyListeners(String componentName, String key, Object value) {
        for (DataStoreUpdateListener listener : this.listeners) {
            try {
                listener.onUpdate(componentName, key, value);
            }
            catch (Throwable t) {
                logger.warn("99-0", "", "", "Failed to notify data store update listener. ComponentName: " + componentName + " Key: " + key, t);
            }
        }
    }
}

