/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kamelets.utils.transform;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeProperty;
import org.apache.camel.util.ObjectHelper;

public class TimestampRouter {
    public void process(@ExchangeProperty(value="topicFormat") String topicFormat, @ExchangeProperty(value="timestampFormat") String timestampFormat, @ExchangeProperty(value="timestampHeaderName") String timestampHeaderName, Exchange ex) {
        Pattern TOPIC = Pattern.compile("$[topic]", 16);
        Pattern TIMESTAMP = Pattern.compile("$[timestamp]", 16);
        SimpleDateFormat fmt = new SimpleDateFormat(timestampFormat);
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        String topicName = (String)ex.getMessage().getHeader("kafka.TOPIC", String.class);
        Object rawTimestamp = ex.getMessage().getHeader(timestampHeaderName);
        long timestamp = rawTimestamp instanceof Long ? (Long)rawTimestamp : (rawTimestamp instanceof Instant ? ((Instant)rawTimestamp).toEpochMilli() : ((Long)rawTimestamp).longValue());
        if (ObjectHelper.isNotEmpty((Object)timestamp)) {
            String updatedTopic;
            String formattedTimestamp = fmt.format(new Date(timestamp));
            if (ObjectHelper.isNotEmpty((String)topicName)) {
                String replace1 = TOPIC.matcher(topicFormat).replaceAll(Matcher.quoteReplacement(topicName));
                updatedTopic = TIMESTAMP.matcher(replace1).replaceAll(Matcher.quoteReplacement(formattedTimestamp));
            } else {
                String replace1 = TOPIC.matcher(topicFormat).replaceAll(Matcher.quoteReplacement(""));
                updatedTopic = TIMESTAMP.matcher(replace1).replaceAll(Matcher.quoteReplacement(formattedTimestamp));
            }
            ex.getMessage().setHeader("kafka.OVERRIDE_TOPIC", (Object)updatedTopic);
        }
    }
}

