/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kamelets.utils.format;

import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.kamelets.utils.format.spi.DataTypeConverter;
import org.apache.camel.kamelets.utils.format.spi.DataTypeConverterResolver;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataTypeConverterResolver
implements DataTypeConverterResolver {
    public static final String DATA_TYPE_CONVERTER_RESOURCE_PATH = "META-INF/services/org/apache/camel/datatype/converter/";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDataTypeConverterResolver.class);

    @Override
    public Optional<DataTypeConverter> resolve(String scheme, String name, CamelContext context) {
        String converterName = String.format("%s-%s", scheme, name);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Resolving data type converter {} via: {}{}", new Object[]{converterName, DATA_TYPE_CONVERTER_RESOURCE_PATH, converterName});
        }
        Optional<DataTypeConverter> converter = this.findConverter(converterName, context);
        if (this.getLog().isDebugEnabled() && converter.isPresent()) {
            this.getLog().debug("Found data type converter: {} via type: {} via: {}{}", new Object[]{converterName, ObjectHelper.name(converter.getClass()), DATA_TYPE_CONVERTER_RESOURCE_PATH, converterName});
        }
        return converter;
    }

    private Optional<DataTypeConverter> findConverter(String name, CamelContext context) {
        return ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getBootstrapFactoryFinder(DATA_TYPE_CONVERTER_RESOURCE_PATH).newInstance(name, DataTypeConverter.class);
    }

    protected Logger getLog() {
        return LOG;
    }
}

