/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer;

import org.apache.camel.component.kafka.KafkaConsumer;
import org.apache.camel.component.kafka.consumer.AbstractCommitManager;
import org.apache.camel.component.kafka.consumer.OffsetCache;
import org.apache.camel.spi.StateRepository;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitToOffsetManager
extends AbstractCommitManager {
    private static final Logger LOG = LoggerFactory.getLogger(CommitToOffsetManager.class);
    private final OffsetCache offsetCache = new OffsetCache();
    private final StateRepository<String, String> offsetRepository = this.configuration.getOffsetRepository();

    public CommitToOffsetManager(Consumer<?, ?> consumer, KafkaConsumer kafkaConsumer, String threadId, String printableTopic) {
        super(consumer, kafkaConsumer, threadId, printableTopic);
    }

    @Override
    public void commit(TopicPartition partition) {
        Long offset = this.offsetCache.getOffset(partition);
        if (offset == null) {
            return;
        }
        this.saveStateToOffsetRepository(partition, offset, this.offsetRepository);
    }

    @Override
    public void forceCommit(TopicPartition partition, long partitionLastOffset) {
        this.saveStateToOffsetRepository(partition, partitionLastOffset, this.offsetRepository);
    }

    private void saveStateToOffsetRepository(TopicPartition partition, long partitionLastOffset, StateRepository<String, String> offsetRepository) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Saving offset repository state {} [topic: {} partition: {} offset: {}]", new Object[]{this.threadId, partition.topic(), partition.partition(), partitionLastOffset});
        }
        offsetRepository.setState((Object)CommitToOffsetManager.serializeOffsetKey(partition), (Object)CommitToOffsetManager.serializeOffsetValue(partitionLastOffset));
    }

    @Override
    public void commit() {
    }

    private static String serializeOffsetKey(TopicPartition topicPartition) {
        return topicPartition.topic() + "/" + topicPartition.partition();
    }

    private static String serializeOffsetValue(long offset) {
        return String.valueOf(offset);
    }

    @Override
    public void recordOffset(TopicPartition partition, long partitionLastOffset) {
        if (partitionLastOffset == -1L) {
            return;
        }
        this.offsetCache.recordOffset(partition, partitionLastOffset);
    }
}

