/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer.support;

import java.util.Set;
import org.apache.camel.component.kafka.consumer.support.KafkaConsumerResumeAdapter;
import org.apache.camel.component.kafka.consumer.support.KafkaRecordProcessor;
import org.apache.camel.component.kafka.consumer.support.KafkaResumable;
import org.apache.camel.spi.StateRepository;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffsetKafkaConsumerResumeAdapter
implements KafkaConsumerResumeAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(OffsetKafkaConsumerResumeAdapter.class);
    private final StateRepository<String, String> offsetRepository;
    private Consumer<?, ?> consumer;

    public OffsetKafkaConsumerResumeAdapter(StateRepository<String, String> offsetRepository) {
        this.offsetRepository = offsetRepository;
    }

    @Override
    public void setConsumer(Consumer<?, ?> consumer) {
        this.consumer = consumer;
    }

    @Override
    public void setKafkaResumable(KafkaResumable kafkaResumable) {
    }

    private void resumeFromOffset(Consumer<?, ?> consumer, TopicPartition topicPartition, String offsetState) {
        long offset = KafkaRecordProcessor.deserializeOffsetValue(offsetState) + 1L;
        LOG.debug("Resuming partition {} from offset {} from state", (Object)topicPartition.partition(), (Object)offset);
        consumer.seek(topicPartition, offset);
    }

    public void resume() {
        Set assignments = this.consumer.assignment();
        for (TopicPartition topicPartition : assignments) {
            String offsetState = (String)this.offsetRepository.getState((Object)KafkaRecordProcessor.serializeOffsetKey(topicPartition));
            if (offsetState == null || offsetState.isEmpty()) continue;
            this.resumeFromOffset(this.consumer, topicPartition, offsetState);
        }
    }
}

