/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer;

import org.apache.camel.component.kafka.KafkaConsumer;
import org.apache.camel.component.kafka.consumer.AbstractCommitManager;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoopCommitManager
extends AbstractCommitManager {
    private static final Logger LOG = LoggerFactory.getLogger(NoopCommitManager.class);

    public NoopCommitManager(Consumer<?, ?> consumer, KafkaConsumer kafkaConsumer, String threadId, String printableTopic) {
        super(consumer, kafkaConsumer, threadId, printableTopic);
    }

    @Override
    public void commit() {
        LOG.info("Auto commit on {} from {} is enabled via Kafka consumer (NO-OP)", (Object)this.threadId, (Object)this.printableTopic);
    }

    @Override
    public void commit(TopicPartition partition) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Auto commit to offset {} from topic {} is disabled (NO-OP)", (Object)this.threadId, (Object)partition.topic());
        }
    }

    @Override
    public void recordOffset(TopicPartition partition, long partitionLastOffset) {
    }
}

