/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.environment.spring.data.jdbc;

import java.util.LinkedHashMap;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.log.Log;
import org.anyline.log.LogProxy;
import org.anyline.metadata.Column;
import org.anyline.metadata.Metadata;
import org.anyline.metadata.Table;
import org.anyline.util.BasicUtil;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;

public class SpringJDBCUtil {
    private static Log log = LogProxy.get(SpringJDBCUtil.class);

    public static <T extends Column> LinkedHashMap<String, T> columns(DriverAdapter adapter, DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, Table table, SqlRowSet set) throws Exception {
        if (null == columns) {
            columns = new LinkedHashMap();
        }
        SqlRowSetMetaData rsm = set.getMetaData();
        for (int i = 1; i <= rsm.getColumnCount(); ++i) {
            Column column;
            String name = rsm.getColumnName(i);
            if (BasicUtil.isEmpty((Object)name) || null != (column = (Column)columns.get(name.toUpperCase())) || !create) continue;
            if (BasicUtil.isEmpty((Object)(column = SpringJDBCUtil.column(adapter, runtime, column, rsm, i)).getName())) {
                column.setName(name);
            }
            columns.put(column.getName().toUpperCase(), column);
        }
        return columns;
    }

    public static Column column(DriverAdapter adapter, DataRuntime runtime, Column column, SqlRowSetMetaData rsm, int index) {
        if (null == column) {
            column = new Column();
            String catalog = null;
            String schema = null;
            try {
                catalog = (String)BasicUtil.evl((Object[])new String[]{rsm.getCatalogName(index)});
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getCatalogName]");
            }
            try {
                schema = (String)BasicUtil.evl((Object[])new String[]{rsm.getSchemaName(index)});
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getSchemaName]");
            }
            adapter.correctSchemaFromJDBC(runtime, (Metadata)column, catalog, schema);
            try {
                column.setClassName(rsm.getColumnClassName(index));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnClassName]");
            }
            try {
                column.currency(Boolean.valueOf(rsm.isCurrency(index)));
            }
            catch (Exception e) {
                column.caseSensitive(Boolean.valueOf(rsm.isCaseSensitive(index)));
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:isCurrency]");
            }
            try {
                column.setOriginName(rsm.getColumnName(index));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnName]");
            }
            try {
                column.setName(rsm.getColumnLabel(index));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnLabel]");
            }
            try {
                column.setPrecision(Integer.valueOf(rsm.getPrecision(index)));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getPrecision]");
            }
            try {
                column.setScale(Integer.valueOf(rsm.getScale(index)));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getScale]");
            }
            try {
                column.setDisplaySize(Integer.valueOf(rsm.getColumnDisplaySize(index)));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnDisplaySize]");
            }
            try {
                column.setSigned(Boolean.valueOf(rsm.isSigned(index)));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:isSigned]");
            }
            try {
                column.setTable(rsm.getTableName(index));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getTableName]");
            }
            try {
                column.setType(Integer.valueOf(rsm.getColumnType(index)));
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnType]");
            }
            try {
                String jdbcType = rsm.getColumnTypeName(index);
                column.setJdbcType(jdbcType);
                if (BasicUtil.isEmpty((Object)column.getTypeName())) {
                    column.setTypeName(jdbcType);
                }
            }
            catch (Exception e) {
                log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnTypeName]");
            }
            adapter.typeMetadata(runtime, column);
        }
        return column;
    }
}

