/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.xss.core;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import net.dreamlu.mica.xss.core.XssCleaner;
import net.dreamlu.mica.xss.core.XssHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonXssClean
extends JsonDeserializer<String> {
    private static final Logger log = LoggerFactory.getLogger(JacksonXssClean.class);
    private final XssCleaner xssCleaner;

    public String deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
        String text = p.getValueAsString();
        if (text == null) {
            return null;
        }
        if (XssHolder.isEnabled()) {
            String value = this.xssCleaner.clean(text);
            log.debug("Json property value:{} cleaned up by mica-xss, current value is:{}.", (Object)text, (Object)value);
            return value;
        }
        return text;
    }

    public JacksonXssClean(XssCleaner xssCleaner) {
        this.xssCleaner = xssCleaner;
    }
}

