/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.http;

import java.io.IOException;
import java.io.Serializable;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.dreamlu.mica.core.retry.IRetry;
import net.dreamlu.mica.core.retry.RetryCallback;
import net.dreamlu.mica.http.HttpResponse;
import net.dreamlu.mica.http.ResponseSpec;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RetryInterceptor
implements Interceptor {
    private final IRetry retry;
    @Nullable
    private final Predicate<ResponseSpec> respPredicate;

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        return (Response)this.retry.execute((RetryCallback & Serializable)() -> {
            Response response = chain.proceed(request);
            if (this.respPredicate == null) {
                return response;
            }
            ResponseBody body = response.peekBody(Long.MAX_VALUE);
            try (HttpResponse httpResponse = new HttpResponse(response);){
                if (this.respPredicate.test(httpResponse)) {
                    throw new IOException("Http Retry ResponsePredicate test Failure.");
                }
            }
            return response.newBuilder().body(body).build();
        });
    }

    public RetryInterceptor(IRetry retry, @Nullable Predicate<ResponseSpec> respPredicate) {
        this.retry = retry;
        this.respPredicate = respPredicate;
    }
}

