/*
 * Decompiled with CFR 0.152.
 */
package io.seata.tm.api;

import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.core.exception.TransactionException;
import io.seata.tm.api.GlobalTransaction;
import io.seata.tm.api.GlobalTransactionContext;
import io.seata.tm.api.TransactionalExecutor;
import io.seata.tm.api.transaction.TransactionHook;
import io.seata.tm.api.transaction.TransactionHookManager;
import io.seata.tm.api.transaction.TransactionInfo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionalTemplate.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(TransactionalExecutor business) throws Throwable {
        GlobalTransaction tx = GlobalTransactionContext.getCurrentOrCreate();
        TransactionInfo txInfo = business.getTransactionInfo();
        if (txInfo == null) {
            throw new ShouldNeverHappenException("transactionInfo does not exist");
        }
        try {
            this.beginTransaction(txInfo, tx);
            Object rs = null;
            try {
                rs = business.execute();
            }
            catch (Throwable ex) {
                this.completeTransactionAfterThrowing(txInfo, tx, ex);
                throw ex;
            }
            this.commitTransaction(tx);
            Object object = rs;
            return object;
        }
        finally {
            this.triggerAfterCompletion();
            this.cleanUp();
        }
    }

    private void completeTransactionAfterThrowing(TransactionInfo txInfo, GlobalTransaction tx, Throwable ex) throws TransactionalExecutor.ExecutionException {
        if (txInfo != null && txInfo.rollbackOn(ex)) {
            try {
                this.rollbackTransaction(tx, ex);
            }
            catch (TransactionException txe) {
                throw new TransactionalExecutor.ExecutionException(tx, (Throwable)txe, TransactionalExecutor.Code.RollbackFailure, ex);
            }
        } else {
            this.commitTransaction(tx);
        }
    }

    private void commitTransaction(GlobalTransaction tx) throws TransactionalExecutor.ExecutionException {
        try {
            this.triggerBeforeCommit();
            tx.commit();
            this.triggerAfterCommit();
        }
        catch (TransactionException txe) {
            throw new TransactionalExecutor.ExecutionException(tx, txe, TransactionalExecutor.Code.CommitFailure);
        }
    }

    private void rollbackTransaction(GlobalTransaction tx, Throwable ex) throws TransactionException, TransactionalExecutor.ExecutionException {
        this.triggerBeforeRollback();
        tx.rollback();
        this.triggerAfterRollback();
        throw new TransactionalExecutor.ExecutionException(tx, TransactionalExecutor.Code.RollbackDone, ex);
    }

    private void beginTransaction(TransactionInfo txInfo, GlobalTransaction tx) throws TransactionalExecutor.ExecutionException {
        try {
            this.triggerBeforeBegin();
            tx.begin(txInfo.getTimeOut(), txInfo.getName());
            this.triggerAfterBegin();
        }
        catch (TransactionException txe) {
            throw new TransactionalExecutor.ExecutionException(tx, txe, TransactionalExecutor.Code.BeginFailure);
        }
    }

    private void triggerBeforeBegin() {
        for (TransactionHook hook : this.getCurrentHooks()) {
            try {
                hook.beforeBegin();
            }
            catch (Exception e) {
                LOGGER.error("Failed execute beforeBegin in hook " + e.getMessage());
            }
        }
    }

    private void triggerAfterBegin() {
        for (TransactionHook hook : this.getCurrentHooks()) {
            try {
                hook.afterBegin();
            }
            catch (Exception e) {
                LOGGER.error("Failed execute afterBegin in hook " + e.getMessage());
            }
        }
    }

    private void triggerBeforeRollback() {
        for (TransactionHook hook : this.getCurrentHooks()) {
            try {
                hook.beforeRollback();
            }
            catch (Exception e) {
                LOGGER.error("Failed execute beforeRollback in hook " + e.getMessage());
            }
        }
    }

    private void triggerAfterRollback() {
        for (TransactionHook hook : this.getCurrentHooks()) {
            try {
                hook.afterRollback();
            }
            catch (Exception e) {
                LOGGER.error("Failed execute afterRollback in hook " + e.getMessage());
            }
        }
    }

    private void triggerBeforeCommit() {
        for (TransactionHook hook : this.getCurrentHooks()) {
            try {
                hook.beforeCommit();
            }
            catch (Exception e) {
                LOGGER.error("Failed execute beforeCommit in hook " + e.getMessage());
            }
        }
    }

    private void triggerAfterCommit() {
        for (TransactionHook hook : this.getCurrentHooks()) {
            try {
                hook.afterCommit();
            }
            catch (Exception e) {
                LOGGER.error("Failed execute afterCommit in hook " + e.getMessage());
            }
        }
    }

    private void triggerAfterCompletion() {
        for (TransactionHook hook : this.getCurrentHooks()) {
            try {
                hook.afterCompletion();
            }
            catch (Exception e) {
                LOGGER.error("Failed execute afterCompletion in hook " + e.getMessage());
            }
        }
    }

    private void cleanUp() {
        TransactionHookManager.clear();
    }

    private List<TransactionHook> getCurrentHooks() {
        return TransactionHookManager.getHooks();
    }
}

