/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.handlers;

import io.netty.buffer.ByteBuf;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.ArrayDeque;
import java.util.Deque;
import org.jboss.resteasy.reactive.client.impl.RestClientRequestContext;
import org.jboss.resteasy.reactive.common.core.BlockingNotAllowedException;

class VertxClientInputStream
extends InputStream {
    public static final String MAX_REQUEST_SIZE_KEY = "io.quarkus.max-request-size";
    private final VertxBlockingInput exchange;
    private boolean closed;
    private boolean finished;
    private ByteBuf pooled;
    private final RestClientRequestContext vertxResteasyReactiveRequestContext;

    public VertxClientInputStream(HttpClientResponse response, long timeout, RestClientRequestContext vertxResteasyReactiveRequestContext) {
        this.vertxResteasyReactiveRequestContext = vertxResteasyReactiveRequestContext;
        this.exchange = new VertxBlockingInput(response, timeout);
    }

    public VertxClientInputStream(HttpClientResponse request, long timeout, ByteBuf existing, RestClientRequestContext vertxResteasyReactiveRequestContext) {
        this.vertxResteasyReactiveRequestContext = vertxResteasyReactiveRequestContext;
        this.exchange = new VertxBlockingInput(request, timeout);
        this.pooled = existing;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int read = this.read(b);
        if (read == -1) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        this.readIntoBuffer();
        if (this.finished) {
            return -1;
        }
        if (len == 0) {
            return 0;
        }
        ByteBuf buffer = this.pooled;
        int copied = Math.min(len, buffer.readableBytes());
        buffer.readBytes(b, off, copied);
        if (!buffer.isReadable()) {
            this.pooled.release();
            this.pooled = null;
        }
        return copied;
    }

    private void readIntoBuffer() throws IOException {
        if (this.pooled == null && !this.finished) {
            this.pooled = this.exchange.readBlocking();
            if (this.pooled == null) {
                this.finished = true;
                this.pooled = null;
            }
        }
    }

    @Override
    public int available() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        if (this.finished) {
            return 0;
        }
        return this.exchange.readBytesAvailable();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            while (!this.finished) {
                this.readIntoBuffer();
                if (this.pooled == null) continue;
                this.pooled.release();
                this.pooled = null;
            }
        }
        catch (IOException | RuntimeException e) {
            throw e;
        }
        finally {
            if (this.pooled != null) {
                this.pooled.release();
                this.pooled = null;
            }
            this.finished = true;
        }
    }

    public static class VertxBlockingInput
    implements Handler<Buffer> {
        protected final HttpClientResponse request;
        protected Buffer input1;
        protected Deque<Buffer> inputOverflow;
        protected boolean waiting = false;
        protected boolean eof = false;
        protected Throwable readException;
        private final long timeout;

        public VertxBlockingInput(HttpClientResponse response, long timeout) {
            this.request = response;
            this.timeout = timeout;
            response.pause();
            response.handler((Handler)this);
            try {
                response.endHandler((Handler)new Handler<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handle(Void event) {
                        VertxBlockingInput vertxBlockingInput = this;
                        synchronized (vertxBlockingInput) {
                            eof = true;
                            if (waiting) {
                                this.notify();
                            }
                        }
                    }
                });
                response.exceptionHandler((Handler)new Handler<Throwable>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handle(Throwable event) {
                        VertxBlockingInput vertxBlockingInput = this;
                        synchronized (vertxBlockingInput) {
                            readException = new IOException(event);
                            if (input1 != null) {
                                input1.getByteBuf().release();
                                input1 = null;
                            }
                            if (inputOverflow != null) {
                                Buffer d = inputOverflow.poll();
                                while (d != null) {
                                    d.getByteBuf().release();
                                    d = inputOverflow.poll();
                                }
                            }
                            if (waiting) {
                                this.notify();
                            }
                        }
                    }
                });
                response.fetch(1L);
            }
            catch (IllegalStateException e) {
                this.eof = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ByteBuf readBlocking() throws IOException {
            long expire = System.currentTimeMillis() + this.timeout;
            VertxBlockingInput vertxBlockingInput = this;
            synchronized (vertxBlockingInput) {
                while (this.input1 == null && !this.eof && this.readException == null) {
                    long rem = expire - System.currentTimeMillis();
                    if (rem <= 0L) {
                        this.request.netSocket().close();
                        IOException throwable = new IOException("Read timed out");
                        this.readException = throwable;
                        throw throwable;
                    }
                    try {
                        if (Context.isOnEventLoopThread()) {
                            throw new BlockingNotAllowedException("Attempting a blocking read on io thread");
                        }
                        this.waiting = true;
                        this.wait(rem);
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException(e.getMessage());
                    }
                    finally {
                        this.waiting = false;
                    }
                }
                if (this.readException != null) {
                    throw new IOException(this.readException);
                }
                Buffer ret = this.input1;
                this.input1 = null;
                if (this.inputOverflow != null) {
                    this.input1 = this.inputOverflow.poll();
                    if (this.input1 == null) {
                        this.request.fetch(1L);
                    }
                } else if (!this.eof) {
                    this.request.fetch(1L);
                }
                return ret == null ? null : ret.getByteBuf();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(Buffer event) {
            VertxBlockingInput vertxBlockingInput = this;
            synchronized (vertxBlockingInput) {
                if (this.input1 == null) {
                    this.input1 = event;
                } else {
                    if (this.inputOverflow == null) {
                        this.inputOverflow = new ArrayDeque<Buffer>();
                    }
                    this.inputOverflow.add(event);
                }
                if (this.waiting) {
                    this.notifyAll();
                }
            }
        }

        public int readBytesAvailable() {
            if (this.input1 != null) {
                return this.input1.getByteBuf().readableBytes();
            }
            String length = this.request.getHeader(HttpHeaders.CONTENT_LENGTH);
            if (length == null) {
                return 0;
            }
            try {
                return Integer.parseInt(length);
            }
            catch (NumberFormatException e) {
                Long.parseLong(length);
                return Integer.MAX_VALUE;
            }
        }
    }
}

