/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.jwt;

import io.helidon.common.Errors;
import io.helidon.security.jwt.ClaimValidator;
import io.helidon.security.jwt.Jwt;
import io.helidon.security.jwt.JwtValidator;
import java.util.List;

class JwtValidators
implements JwtValidator {
    private final List<ClaimValidator> claimValidators;

    JwtValidators(JwtValidator.Builder builder) {
        this.claimValidators = List.copyOf(builder.claimValidators());
    }

    @Override
    public Errors validate(Jwt jwt) {
        Errors.Collector collector = Errors.collector();
        this.claimValidators.forEach(claimValidator -> claimValidator.validate(jwt, collector, this.claimValidators));
        return collector.collect();
    }
}

