/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.jwt;

import io.helidon.common.Errors;
import io.helidon.security.jwt.ClaimValidator;
import io.helidon.security.jwt.InstantValidator;
import io.helidon.security.jwt.Jwt;
import java.time.Instant;
import java.util.List;
import java.util.Optional;

public final class IssueTimeValidator
extends InstantValidator {
    private IssueTimeValidator(Builder builder) {
        super(builder);
    }

    public static Builder builder() {
        return (Builder)new Builder().addClaim("iat");
    }

    @Override
    public void validate(Jwt token, Errors.Collector collector, List<ClaimValidator> validators) {
        Optional<Instant> issueTime = token.issueTime();
        issueTime.ifPresent(it -> {
            if (this.latest().isBefore((Instant)it)) {
                collector.fatal((Object)token, "Token was not issued in the past: " + String.valueOf(it));
            }
        });
        super.validate("issueTime", issueTime, collector);
    }

    public static final class Builder
    extends InstantValidator.BaseBuilder<Builder, IssueTimeValidator> {
        private Builder() {
        }

        public IssueTimeValidator build() {
            return new IssueTimeValidator(this);
        }
    }
}

