/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics;

import io.helidon.metrics.api.Meter;
import io.helidon.metrics.api.MetricsConfig;
import io.helidon.microprofile.metrics.HelidonMetric;
import io.helidon.microprofile.metrics.MetricFactory;
import io.helidon.microprofile.metrics.MetricInstance;
import io.helidon.microprofile.metrics.MetricsForMetadata;
import io.helidon.microprofile.metrics.RegistryFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;

class MetricStore {
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final Map<MetricID, HelidonMetric<?>> allMetrics = new ConcurrentHashMap();
    private final Map<String, List<MetricID>> allMetricIDsByName = new ConcurrentHashMap<String, List<MetricID>>();
    private final Map<String, Metadata> allMetadata = new ConcurrentHashMap<String, Metadata>();
    private final Map<String, Set<String>> tagNameSets = new HashMap<String, Set<String>>();
    private final Map<String, Class<? extends Metric>> metricTypes = new HashMap<String, Class<? extends Metric>>();
    private final MetricFactory metricFactory;
    private final String scope;
    private final Consumer<HelidonMetric<?>> doRemove;
    private volatile MetricsConfig metricsConfig;

    private MetricStore(MetricsConfig metricsConfig, MetricFactory metricFactory, String scope, Consumer<HelidonMetric<?>> doRemove) {
        this.metricsConfig = metricsConfig;
        this.metricFactory = metricFactory;
        this.scope = scope;
        this.doRemove = doRemove;
    }

    static MetricStore create(MetricsConfig metricsConfig, MetricFactory metricFactory, String scope, Consumer<HelidonMetric<?>> doRemove) {
        return new MetricStore(metricsConfig, metricFactory, scope, doRemove);
    }

    static Tag[] tags(Iterable<Map.Entry<String, String>> entries) {
        ArrayList result = new ArrayList();
        entries.forEach(entry -> result.add(new Tag((String)entry.getKey(), (String)entry.getValue())));
        return result.toArray(new Tag[0]);
    }

    void update(MetricsConfig metricsConfig) {
        this.metricsConfig = metricsConfig;
    }

    <U extends Metric> U getOrRegisterMetric(MetricID metricID, Class<U> clazz) {
        return this.getOrRegisterMetric(metricID.getName(), clazz, () -> this.allMetrics.get(metricID), () -> metricID, () -> this.getConsistentMetadataLocked(metricID.getName()), new Tag[0]);
    }

    <U extends Metric> U getOrRegisterMetric(String metricName, Class<U> clazz, Tag ... tags) {
        return this.getOrRegisterMetric(metricName, clazz, () -> this.getMetricLocked(metricName, tags), () -> new MetricID(metricName, tags), () -> this.getConsistentMetadataLocked(metricName), tags);
    }

    <U extends Metric, M extends Meter> U getOrRegisterMetric(Metadata newMetadata, Class<U> clazz, Tag ... tags) {
        return this.getOrRegisterMetric(() -> this.createEnabledAwareMetric(clazz, newMetadata, tags), newMetadata, clazz, tags);
    }

    <U extends Metric> U getOrRegisterMetric(Supplier<HelidonMetric<?>> metricFactory, Metadata newMetadata, Class<U> clazz, Tag ... tags) {
        Class<? extends Metric> newBaseType = MetricStore.baseMetricClass(clazz);
        return (U)this.writeAccess(() -> {
            this.enforceConsistentType(newMetadata.getName(), clazz);
            MetricID newMetricID = new MetricID(newMetadata.getName(), tags);
            this.checkOrStoreTagNames(newMetricID.getName(), newMetricID.getTags().keySet());
            this.checkOrStoreMetadata(newMetadata);
            HelidonMetric<?> metric = this.getMetricLocked(newMetadata.getName(), tags);
            if (metric == null) {
                this.getConsistentMetadataLocked(newMetadata);
                metric = this.registerMetricLocked(newMetricID, (HelidonMetric)metricFactory.get());
                return (Metric)clazz.cast(metric);
            }
            this.ensureConsistentMetricTypes(metric, newBaseType, () -> newMetricID);
            return (Metric)clazz.cast(metric);
        });
    }

    <R extends Number> Gauge<R> getOrRegisterGauge(String name, Supplier<R> valueSupplier, Tag ... tags) {
        return this.getOrRegisterGauge(() -> this.getMetricLocked(name, tags), () -> this.getConsistentMetadataLocked(name), () -> new MetricID(name, tags), (Metadata metadata) -> this.metricFactory.gauge(this.scope, (Metadata)metadata, valueSupplier, tags));
    }

    <R extends Number> Gauge<R> getOrRegisterGauge(Metadata newMetadata, Supplier<R> valueSupplier, Tag ... tags) {
        String metricName = newMetadata.getName();
        return this.getOrRegisterGauge(() -> this.getMetricLocked(metricName, tags), () -> this.getConsistentMetadataLocked(newMetadata), () -> new MetricID(metricName, tags), (Metadata metadata) -> this.metricFactory.gauge(this.scope, newMetadata, valueSupplier, tags));
    }

    <R extends Number> Gauge<R> getOrRegisterGauge(MetricID metricID, Supplier<R> valueSupplier) {
        return this.getOrRegisterGauge(() -> this.allMetrics.get(metricID), () -> this.allMetadata.get(metricID.getName()), () -> metricID, (Metadata metadata) -> this.metricFactory.gauge(this.scope, (Metadata)metadata, valueSupplier, new Tag[0]));
    }

    boolean remove(MetricID metricID) {
        return this.writeAccess(() -> {
            HelidonMetric<?> doomedMetric;
            List<MetricID> metricIDsForName = this.allMetricIDsByName.get(metricID.getName());
            if (metricIDsForName == null) {
                return false;
            }
            metricIDsForName.remove(metricID);
            if (metricIDsForName.isEmpty()) {
                this.allMetricIDsByName.remove(metricID.getName());
                this.allMetadata.remove(metricID.getName());
                this.tagNameSets.remove(metricID.getName());
                this.metricTypes.remove(metricID.getName());
            }
            if ((doomedMetric = this.allMetrics.remove(metricID)) != null) {
                doomedMetric.markAsDeleted();
            }
            this.doRemove.accept(doomedMetric);
            return doomedMetric != null;
        });
    }

    boolean remove(String name) {
        return this.writeAccess(() -> {
            List<MetricID> doomedMetricsIDs = this.allMetricIDsByName.get(name);
            if (doomedMetricsIDs == null) {
                return false;
            }
            boolean result = false;
            for (MetricID metricID : doomedMetricsIDs) {
                HelidonMetric<?> doomedMetric = this.allMetrics.get(metricID);
                if (doomedMetric == null) continue;
                doomedMetric.markAsDeleted();
                result |= this.allMetrics.remove(metricID) != null;
                this.doRemove.accept(doomedMetric);
            }
            this.allMetricIDsByName.remove(name);
            this.allMetadata.remove(name);
            this.tagNameSets.remove(name);
            this.metricTypes.remove(name);
            return result;
        });
    }

    void removeMatching(MetricFilter filter) {
        this.writeAccess(() -> {
            try {
                this.allMetrics.entrySet().stream().filter(entry -> filter.matches((MetricID)entry.getKey(), (Metric)entry.getValue())).forEach(this::removeLocked);
                return null;
            }
            catch (Exception e) {
                throw new RuntimeException("Error removing using filter " + String.valueOf(filter), e);
            }
        });
    }

    SortedSet<String> getNames() {
        return new TreeSet<String>(this.allMetricIDsByName.keySet());
    }

    SortedSet<MetricID> getMetricIDs() {
        return new TreeSet<MetricID>(this.allMetrics.keySet());
    }

    <V> SortedMap<MetricID, V> getSortedMetrics(MetricFilter filter, Class<V> metricClass) {
        Map<MetricID, Object> collected = this.allMetrics.entrySet().stream().filter(it -> metricClass.isAssignableFrom(((HelidonMetric)it.getValue()).getClass())).filter(it -> filter.matches((MetricID)it.getKey(), (Metric)it.getValue())).collect(Collectors.toMap(Map.Entry::getKey, it -> metricClass.cast(it.getValue())));
        return new TreeMap<MetricID, Object>(collected);
    }

    MetricsForMetadata metadataWithIDs(String metricName) {
        return this.readAccess(() -> {
            Metadata metadata = this.allMetadata.get(metricName);
            List<MetricID> metricIDs = this.allMetricIDsByName.get(metricName);
            return metadata == null || metricIDs == null || metricIDs.isEmpty() ? null : new MetricsForMetadata(metadata, metricIDs);
        });
    }

    HelidonMetric<?> metric(MetricID metricID) {
        return this.allMetrics.get(metricID);
    }

    Map<String, Metadata> metadata() {
        return this.allMetadata;
    }

    Metadata metadata(String metricName) {
        return this.allMetadata.get(metricName);
    }

    Map<MetricID, HelidonMetric<?>> metrics() {
        return this.allMetrics;
    }

    MetricInstance untaggedOrFirstMetricInstance(String metricName) {
        return this.readAccess(() -> {
            List<MetricID> metricIDs = this.allMetricIDsByName.get(metricName);
            if (metricIDs == null || metricIDs.isEmpty()) {
                return null;
            }
            MetricID metricID = null;
            for (MetricID candidate : metricIDs) {
                if (metricID != null && !candidate.getTags().isEmpty()) continue;
                metricID = candidate;
            }
            return new MetricInstance(metricID, this.allMetrics.get(metricID));
        });
    }

    List<MetricInstance> metricsWithIDs(String metricName) {
        return this.readAccess(() -> {
            List<MetricID> metricIDs = this.allMetricIDsByName.get(metricName);
            if (metricIDs == null) {
                return Collections.emptyList();
            }
            ArrayList<MetricInstance> result = new ArrayList<MetricInstance>();
            for (MetricID metricID : metricIDs) {
                result.add(new MetricInstance(metricID, this.allMetrics.get(metricID)));
            }
            return result;
        });
    }

    List<MetricID> metricIDs(String metricName) {
        return new ArrayList<MetricID>((Collection)this.allMetricIDsByName.get(metricName));
    }

    Stream<MetricInstance> stream() {
        return this.allMetrics.entrySet().stream().filter(entry -> this.metricsConfig.isMeterEnabled(((MetricID)entry.getKey()).getName(), this.scope)).map(it -> new MetricInstance((MetricID)it.getKey(), (Metric)it.getValue()));
    }

    private static void enforceConsistentTagNames(String metricName, Set<String> existingTagNames, Set<String> newTagNames) {
        if (!existingTagNames.equals(newTagNames)) {
            throw new IllegalArgumentException(String.format("New tag names %s for metric %s conflict with existing tag names %s", newTagNames, metricName, existingTagNames));
        }
    }

    private static void enforceConsistentMetadata(Metadata existingMetadata, Metadata newMetadata) {
        if (!MetricStore.metadataMatches(existingMetadata, newMetadata)) {
            throw new IllegalArgumentException("New metadata conflicts with existing metadata with the same name; existing: " + String.valueOf(existingMetadata) + ", new: " + String.valueOf(newMetadata));
        }
    }

    private static <T extends Metadata, U extends Metadata> boolean metadataMatches(T a, U b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.getName().equals(b.getName()) && Objects.equals(a.getDescription(), b.getDescription()) && Objects.equals(a.getUnit(), b.getUnit());
    }

    private static Class<? extends Metric> baseMetricClass(Class<?> clazz) {
        for (Class<? extends Metric> baseClass : RegistryFactory.METRIC_TYPES) {
            if (!baseClass.isAssignableFrom(clazz)) continue;
            return baseClass;
        }
        throw new IllegalArgumentException("Unable to map metric type " + clazz.getName() + " to one of " + String.valueOf(RegistryFactory.METRIC_TYPES));
    }

    private static boolean tagsMatch(Tag[] tags, Map<String, String> tagMap) {
        TreeMap<String, String> newTags = new TreeMap<String, String>();
        for (Tag tag : tags) {
            newTags.put(tag.getTagName(), tag.getTagValue());
        }
        return newTags.equals(tagMap);
    }

    private Set<String> checkOrStoreTagNames(String metricName, Set<String> tagNames) {
        Set<String> currentTagNames = this.tagNameSets.get(metricName);
        if (currentTagNames == null) {
            return this.tagNameSets.put(metricName, tagNames);
        }
        MetricStore.enforceConsistentTagNames(metricName, currentTagNames, tagNames);
        return tagNames;
    }

    private Metadata checkOrStoreMetadata(Metadata candidateMetadata) {
        Metadata currentMetadata = this.allMetadata.get(candidateMetadata.getName());
        if (currentMetadata == null) {
            return this.allMetadata.put(candidateMetadata.getName(), candidateMetadata);
        }
        MetricStore.enforceConsistentMetadata(currentMetadata, candidateMetadata);
        return candidateMetadata;
    }

    private void enforceConsistentType(String metricName, Class<? extends Metric> newType) {
        Class<? extends Metric> metricType = this.metricTypes.get(metricName);
        if (metricType != null && !metricType.isAssignableFrom(newType)) {
            throw new IllegalArgumentException(String.format("Attempt to register metric %s of type %s but the name is already associated with a metric of type %s", metricName, newType.getName(), metricType.getName()));
        }
    }

    private <R extends Number> Gauge<R> getOrRegisterGauge(Supplier<HelidonMetric<?>> metricFinder, Supplier<Metadata> metadataFinder, Supplier<MetricID> metricIDSupplier, Function<Metadata, Gauge<R>> gaugeFactory) {
        return this.writeAccess(() -> {
            Metadata metadata = (Metadata)metadataFinder.get();
            this.enforceConsistentType(metadata.getName(), Gauge.class);
            HelidonMetric<?> metric = (HelidonMetric<?>)metricFinder.get();
            if (metric == null) {
                metric = this.registerMetricLocked((MetricID)metricIDSupplier.get(), this.createEnabledAwareGauge(metadata, gaugeFactory));
            }
            return (Gauge)metric;
        });
    }

    private void removeLocked(Map.Entry<MetricID, HelidonMetric<?>> entry) {
        this.remove(entry.getKey());
    }

    private <U extends Metric> U getOrRegisterMetric(String metricName, Class<U> clazz, Supplier<HelidonMetric<?>> metricFactory, Supplier<MetricID> metricIDFactory, Supplier<Metadata> metadataFactory, Tag ... tags) {
        Class<? extends Metric> newBaseType = MetricStore.baseMetricClass(clazz);
        return (U)this.writeAccess(() -> {
            this.enforceConsistentType(metricName, clazz);
            HelidonMetric<?> metric = (HelidonMetric<?>)metricFactory.get();
            MetricID newMetricID = (MetricID)metricIDFactory.get();
            this.checkOrStoreTagNames(newMetricID.getName(), newMetricID.getTags().keySet());
            if (metric == null) {
                Metadata metadata = (Metadata)metadataFactory.get();
                if (metadata == null) {
                    metadata = this.registerMetadataLocked(metricName);
                }
                metric = this.registerMetricLocked(newMetricID, this.createEnabledAwareMetric(clazz, metadata, tags));
            } else {
                this.ensureConsistentMetricTypes(metric, newBaseType, metricIDFactory);
                Metadata existingMetadata = (Metadata)metadataFactory.get();
                if (existingMetadata == null) {
                    throw new IllegalStateException("Could not find existing metadata under name " + metricName + " for existing metric " + String.valueOf(metricIDFactory.get()));
                }
            }
            return (Metric)clazz.cast(metric);
        });
    }

    private HelidonMetric<?> getMetricLocked(String metricName, Tag ... tags) {
        List<MetricID> metricIDsForName = this.allMetricIDsByName.get(metricName);
        if (metricIDsForName == null) {
            return null;
        }
        for (MetricID metricID : metricIDsForName) {
            if (!metricID.getName().equals(metricName) || !MetricStore.tagsMatch(tags, metricID.getTags())) continue;
            return this.allMetrics.get(metricID);
        }
        return null;
    }

    private HelidonMetric<?> registerMetricLocked(MetricID metricID, HelidonMetric<?> metric) {
        if (this.metricsConfig.isMeterEnabled(metricID.getName(), this.scope)) {
            this.allMetrics.put(metricID, metric);
            this.allMetricIDsByName.computeIfAbsent(metricID.getName(), k -> new ArrayList()).add(metricID);
        }
        return metric;
    }

    private Metadata getConsistentMetadataLocked(String metricName) {
        Metadata result = this.allMetadata.get(metricName);
        if (result == null) {
            result = this.registerMetadataLocked(metricName);
        }
        return result;
    }

    private Metadata getConsistentMetadataLocked(Metadata newMetadata) {
        Metadata metadata = this.allMetadata.get(newMetadata.getName());
        if (metadata != null) {
            this.checkOrStoreMetadata(newMetadata);
        } else {
            this.registerMetadataLocked(newMetadata);
        }
        return newMetadata;
    }

    private Metadata registerMetadataLocked(String metricName) {
        return this.registerMetadataLocked(Metadata.builder().withName(metricName).withUnit("none").build());
    }

    private Metadata registerMetadataLocked(Metadata metadata) {
        this.checkOrStoreMetadata(metadata);
        this.allMetadata.put(metadata.getName(), metadata);
        return metadata;
    }

    private void ensureConsistentMetricTypes(HelidonMetric<?> existingMetric, Class<? extends Metric> newBaseType, Supplier<MetricID> metricIDSupplier) {
        if (!MetricStore.baseMetricClass(existingMetric.getClass()).isAssignableFrom(newBaseType)) {
            MetricID tempID = metricIDSupplier.get();
            throw new IllegalArgumentException("Attempt to register new metric of type " + newBaseType.getName() + " when previously-registered metric " + tempID.getName() + String.valueOf(Arrays.asList(tempID.getTagsAsArray())) + " is of incompatible type " + String.valueOf(MetricStore.baseMetricClass(existingMetric.getClass())));
        }
    }

    private <U extends Metric> HelidonMetric<?> createEnabledAwareMetric(Class<U> clazz, Metadata metadata, Tag ... tags) {
        Counter result;
        Class<? extends Metric> baseClass = MetricStore.baseMetricClass(clazz);
        if (baseClass.isAssignableFrom(Counter.class)) {
            result = this.metricFactory.counter(this.scope, metadata, tags);
        } else if (baseClass.isAssignableFrom(Histogram.class)) {
            result = this.metricFactory.summary(this.scope, metadata, tags);
        } else if (baseClass.isAssignableFrom(Timer.class)) {
            result = this.metricFactory.timer(this.scope, metadata, tags);
        } else {
            throw new IllegalArgumentException("Cannot identify correct metric type for " + clazz.getName());
        }
        return (HelidonMetric)result;
    }

    private <R extends Number> HelidonMetric<?> createEnabledAwareGauge(Metadata metadata, Function<Metadata, Gauge<R>> gaugeFactory) {
        return (HelidonMetric)gaugeFactory.apply(metadata);
    }

    private <S> S readAccess(Callable<S> action) {
        return this.access(this.lock.readLock(), action);
    }

    private <S> S writeAccess(Callable<S> action) {
        return this.access(this.lock.writeLock(), action);
    }

    private <S> S access(Lock lock, Callable<S> action) {
        lock.lock();
        try {
            S s = action.call();
            return s;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }
}

