/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics;

import io.helidon.metrics.api.Counter;
import io.helidon.metrics.api.DistributionSummary;
import io.helidon.metrics.api.FunctionalCounter;
import io.helidon.metrics.api.Gauge;
import io.helidon.metrics.api.MeterRegistry;
import io.helidon.metrics.api.MetricsConfig;
import io.helidon.microprofile.metrics.HelidonCounter;
import io.helidon.microprofile.metrics.HelidonGauge;
import io.helidon.microprofile.metrics.HelidonHistogram;
import io.helidon.microprofile.metrics.HelidonMetric;
import io.helidon.microprofile.metrics.HelidonTimer;
import io.helidon.microprofile.metrics.MetricFactory;
import io.helidon.microprofile.metrics.MetricInstance;
import io.helidon.microprofile.metrics.MetricStore;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;

abstract class AbstractRegistry
implements MetricRegistry {
    private static final Tag[] NO_TAGS = new Tag[0];
    private final String scope;
    private final MetricStore metricStore;
    private final MetricFactory metricFactory;

    protected AbstractRegistry(String scope, MetricsConfig metricsConfig, MetricFactory metricFactory) {
        this.scope = scope;
        this.metricStore = MetricStore.create(metricsConfig, metricFactory, scope, this::doRemove);
        this.metricFactory = metricFactory;
    }

    public static boolean isMarkedAsDeleted(Metric metric) {
        return metric instanceof HelidonMetric && ((HelidonMetric)metric).isDeleted();
    }

    public org.eclipse.microprofile.metrics.Counter counter(String name) {
        return this.counter(name, NO_TAGS);
    }

    public org.eclipse.microprofile.metrics.Counter counter(Metadata metadata) {
        return this.counter(metadata, NO_TAGS);
    }

    public org.eclipse.microprofile.metrics.Counter counter(String name, Tag ... tags) {
        return this.metricStore.getOrRegisterMetric(name, org.eclipse.microprofile.metrics.Counter.class, tags);
    }

    public org.eclipse.microprofile.metrics.Counter counter(Metadata metadata, Tag ... tags) {
        return this.metricStore.getOrRegisterMetric(metadata, org.eclipse.microprofile.metrics.Counter.class, tags);
    }

    public org.eclipse.microprofile.metrics.Counter counter(MetricID metricID) {
        return this.metricStore.getOrRegisterMetric(metricID, org.eclipse.microprofile.metrics.Counter.class);
    }

    public org.eclipse.microprofile.metrics.Counter getCounter(MetricID metricID) {
        return this.getMetric(metricID, org.eclipse.microprofile.metrics.Counter.class);
    }

    public Histogram histogram(String name) {
        return this.histogram(name, NO_TAGS);
    }

    public Histogram histogram(Metadata metadata) {
        return this.histogram(metadata, NO_TAGS);
    }

    public Histogram histogram(String name, Tag ... tags) {
        return this.metricStore.getOrRegisterMetric(name, Histogram.class, tags);
    }

    public Histogram histogram(Metadata metadata, Tag ... tags) {
        return this.metricStore.getOrRegisterMetric(metadata, Histogram.class, tags);
    }

    public Histogram histogram(MetricID metricID) {
        return this.metricStore.getOrRegisterMetric(metricID, Histogram.class);
    }

    public Histogram getHistogram(MetricID metricID) {
        return this.getMetric(metricID, Histogram.class);
    }

    public Timer timer(String name) {
        return this.timer(name, NO_TAGS);
    }

    public Timer timer(Metadata metadata) {
        return this.timer(metadata, NO_TAGS);
    }

    public Timer timer(String name, Tag ... tags) {
        return this.metricStore.getOrRegisterMetric(name, Timer.class, tags);
    }

    public Timer timer(Metadata metadata, Tag ... tags) {
        return this.metricStore.getOrRegisterMetric(metadata, Timer.class, tags);
    }

    public Timer timer(MetricID metricID) {
        return this.metricStore.getOrRegisterMetric(metricID, Timer.class);
    }

    public Timer getTimer(MetricID metricID) {
        return this.getMetric(metricID, Timer.class);
    }

    public <T extends Number> org.eclipse.microprofile.metrics.Gauge<T> gauge(String name, Supplier<T> supplier, Tag ... tags) {
        return this.metricStore.getOrRegisterGauge(name, supplier, tags);
    }

    public <T extends Number> org.eclipse.microprofile.metrics.Gauge<T> gauge(MetricID metricID, Supplier<T> supplier) {
        return this.metricStore.getOrRegisterGauge(metricID, supplier);
    }

    public <T extends Number> org.eclipse.microprofile.metrics.Gauge<T> gauge(Metadata metadata, Supplier<T> supplier, Tag ... tags) {
        return this.metricStore.getOrRegisterGauge(metadata, supplier, tags);
    }

    public org.eclipse.microprofile.metrics.Gauge<?> getGauge(MetricID metricID) {
        return this.getMetric(metricID, org.eclipse.microprofile.metrics.Gauge.class);
    }

    public boolean remove(String name) {
        return this.metricStore.remove(name);
    }

    public boolean remove(MetricID metricID) {
        return this.metricStore.remove(metricID);
    }

    public void removeMatching(MetricFilter filter) {
        this.metricStore.removeMatching(filter);
    }

    public SortedSet<String> getNames() {
        return this.metricStore.getNames();
    }

    public SortedSet<MetricID> getMetricIDs() {
        return this.metricStore.getMetricIDs();
    }

    public SortedMap<MetricID, org.eclipse.microprofile.metrics.Gauge> getGauges() {
        return this.getGauges(MetricFilter.ALL);
    }

    public SortedMap<MetricID, org.eclipse.microprofile.metrics.Gauge> getGauges(MetricFilter filter) {
        return this.metricStore.getSortedMetrics(filter, org.eclipse.microprofile.metrics.Gauge.class);
    }

    public SortedMap<MetricID, org.eclipse.microprofile.metrics.Counter> getCounters() {
        return this.getCounters(MetricFilter.ALL);
    }

    public SortedMap<MetricID, org.eclipse.microprofile.metrics.Counter> getCounters(MetricFilter filter) {
        return this.metricStore.getSortedMetrics(filter, org.eclipse.microprofile.metrics.Counter.class);
    }

    public SortedMap<MetricID, Histogram> getHistograms() {
        return this.getHistograms(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Histogram> getHistograms(MetricFilter filter) {
        return this.metricStore.getSortedMetrics(filter, Histogram.class);
    }

    public SortedMap<MetricID, Timer> getTimers() {
        return this.getTimers(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Timer> getTimers(MetricFilter filter) {
        return this.metricStore.getSortedMetrics(filter, Timer.class);
    }

    public Map<String, Metadata> getMetadata() {
        return Collections.unmodifiableMap(this.metricStore.metadata());
    }

    public Metadata getMetadata(String name) {
        return this.metricStore.metadata(name);
    }

    public Map<MetricID, Metric> getMetrics() {
        return Collections.unmodifiableMap(this.metricStore.metrics());
    }

    public SortedMap<MetricID, Metric> getMetrics(MetricFilter filter) {
        return this.metricStore.getSortedMetrics(filter, Metric.class);
    }

    public <T extends Metric> SortedMap<MetricID, T> getMetrics(Class<T> ofType, MetricFilter filter) {
        return this.metricStore.getSortedMetrics(filter, ofType);
    }

    public HelidonMetric<?> getMetric(MetricID metricID) {
        return this.metricStore.metric(metricID);
    }

    public <T extends Metric> T getMetric(MetricID metricID, Class<T> asType) {
        return (T)((Metric)asType.cast(this.metricStore.metric(metricID)));
    }

    org.eclipse.microprofile.metrics.Counter counter(Counter delegate, Metadata metadata, Tag ... tags) {
        return this.metricStore.getOrRegisterMetric(() -> HelidonCounter.create(this.scope, metadata, delegate), metadata, org.eclipse.microprofile.metrics.Counter.class, tags);
    }

    org.eclipse.microprofile.metrics.Gauge<?> gauge(Gauge delegate, Metadata metadata, Tag ... tags) {
        return this.metricStore.getOrRegisterMetric(() -> HelidonGauge.create(this.scope, metadata, delegate), metadata, org.eclipse.microprofile.metrics.Gauge.class, tags);
    }

    org.eclipse.microprofile.metrics.Gauge<?> gauge(FunctionalCounter delegate, Metadata metadata, Tag ... tags) {
        return this.metricStore.getOrRegisterMetric(() -> HelidonGauge.create(this.scope, metadata, delegate), metadata, org.eclipse.microprofile.metrics.Gauge.class, tags);
    }

    Histogram histogram(DistributionSummary delegate, Metadata metadata, Tag ... tags) {
        return this.metricStore.getOrRegisterMetric(() -> HelidonHistogram.create(this.scope, metadata, delegate), metadata, Histogram.class, tags);
    }

    Timer timer(io.helidon.metrics.api.Timer delegate, MeterRegistry meterRegistry, Metadata metadata, Tag ... tags) {
        return this.metricStore.getOrRegisterMetric(() -> HelidonTimer.create(meterRegistry, this.scope, metadata, delegate), metadata, Timer.class, tags);
    }

    void update(MetricsConfig metricsConfig) {
        this.metricStore.update(metricsConfig);
    }

    String scope() {
        return this.scope;
    }

    public String getScope() {
        return this.scope;
    }

    boolean empty() {
        return this.metricStore.metrics().isEmpty();
    }

    public String toString() {
        return this.scope() + ": " + this.metricStore.metrics().size() + " metrics";
    }

    Stream<MetricInstance> stream() {
        return this.metricStore.stream();
    }

    protected List<MetricID> metricIDsForName(String metricName) {
        return this.metricStore.metricIDs(metricName);
    }

    protected <T, R extends Number> org.eclipse.microprofile.metrics.Gauge<R> createGauge(Metadata metadata, T object, Function<T, R> func) {
        return this.createGauge(metadata, () -> (Number)func.apply(object));
    }

    protected abstract <R extends Number> org.eclipse.microprofile.metrics.Gauge<R> createGauge(Metadata var1, Supplier<R> var2);

    protected abstract void doRemove(HelidonMetric<?> var1);

    protected MetricFactory metricFactory() {
        return this.metricFactory;
    }

    public static interface GaugeFactory {

        @FunctionalInterface
        public static interface FunctionBased {
            public <T, R extends Number> org.eclipse.microprofile.metrics.Gauge<R> createGauge(Metadata var1, T var2, Function<T, R> var3);
        }

        @FunctionalInterface
        public static interface SupplierBased {
            public <R extends Number> org.eclipse.microprofile.metrics.Gauge<R> createGauge(Metadata var1, Supplier<R> var2);
        }
    }
}

