/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.cdi;

import io.helidon.microprofile.cdi.ContainerInstanceHolder;
import io.helidon.microprofile.cdi.HelidonContainerImpl;
import io.helidon.microprofile.cdi.Main;
import jakarta.enterprise.inject.se.SeContainer;
import jakarta.enterprise.inject.se.SeContainerInitializer;
import jakarta.enterprise.inject.spi.Extension;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class HelidonContainerInitializer
extends SeContainerInitializer {
    private static final Logger LOGGER = Logger.getLogger(HelidonContainerInitializer.class.getName());
    static final String CONFIG_ALLOW_INITIALIZER = "mp.initializer.allow";
    static final String CONFIG_INITIALIZER_NO_WARN = "mp.initializer.no-warn";
    private final HelidonContainerImpl container = new HelidonContainerImpl();

    public HelidonContainerInitializer() {
        Config config = ConfigProvider.getConfig();
        if (!config.getOptionalValue(CONFIG_ALLOW_INITIALIZER, Boolean.class).orElse(false).booleanValue()) {
            throw new IllegalStateException("Helidon MUST be started using " + Main.class.getName() + ", or through io.helidon.microprofile.server.Server. This is to ensure compatibility with GraalVM native-image. If you want to still use SeContainerInitializer, please configure mp.initializer.allow=true to disable this exception.");
        }
        if (!config.getOptionalValue(CONFIG_INITIALIZER_NO_WARN, Boolean.class).orElse(false).booleanValue()) {
            LOGGER.warning("You are using SeContainerInitializer. This application will not work with GraalVM native-image. You can disable this warning by configuring mp.initializer.no-warn=true.");
        }
        ContainerInstanceHolder.set(this.container);
    }

    public SeContainerInitializer addBeanClasses(Class<?> ... classes) {
        this.container.addBeanClasses(classes);
        return this;
    }

    public SeContainerInitializer addPackages(Class<?> ... packageClasses) {
        this.container.addPackages(packageClasses);
        return this;
    }

    public SeContainerInitializer addPackages(boolean scanRecursively, Class<?> ... packageClasses) {
        this.container.addPackages(scanRecursively, packageClasses);
        return this;
    }

    public SeContainerInitializer addPackages(Package ... packages) {
        this.container.addPackages(packages);
        return this;
    }

    public SeContainerInitializer addPackages(boolean scanRecursively, Package ... packages) {
        this.container.addPackages(scanRecursively, packages);
        return this;
    }

    public SeContainerInitializer addExtensions(Extension ... extensions) {
        this.container.addExtensions(extensions);
        return this;
    }

    public SeContainerInitializer addExtensions(Class<? extends Extension> ... extensions) {
        this.container.addExtensions(extensions);
        return this;
    }

    public SeContainerInitializer enableInterceptors(Class<?> ... interceptorClasses) {
        this.container.enableDecorators(interceptorClasses);
        return this;
    }

    public SeContainerInitializer enableDecorators(Class<?> ... decoratorClasses) {
        this.container.enableDecorators(decoratorClasses);
        return this;
    }

    public SeContainerInitializer selectAlternatives(Class<?> ... alternativeClasses) {
        this.container.selectAlternatives(alternativeClasses);
        return this;
    }

    public SeContainerInitializer selectAlternativeStereotypes(Class<? extends Annotation> ... alternativeStereotypeClasses) {
        this.container.selectAlternativeStereotypes(alternativeStereotypeClasses);
        return this;
    }

    public SeContainerInitializer addProperty(String key, Object value) {
        this.container.addProperty(key, value);
        return this;
    }

    public SeContainerInitializer setProperties(Map<String, Object> properties) {
        this.container.setProperties(properties);
        return this;
    }

    public SeContainerInitializer disableDiscovery() {
        this.container.disableDiscovery();
        return this;
    }

    public SeContainerInitializer setClassLoader(ClassLoader classLoader) {
        this.container.setClassLoader(classLoader);
        return this;
    }

    public SeContainer initialize() {
        if (HelidonContainerImpl.isRuntime()) {
            throw new IllegalStateException("Helidon CDI is already started, cannot create two instances in the same JVM");
        }
        this.container.initInContext();
        return this.container.start();
    }
}

