/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.systemmeters;

import io.helidon.Main;
import io.helidon.common.LazyValue;
import io.helidon.common.resumable.Resumable;
import io.helidon.common.resumable.ResumableSupport;
import io.helidon.metrics.api.Gauge;
import io.helidon.metrics.api.Meter;
import io.helidon.metrics.api.Metrics;
import io.helidon.metrics.api.MetricsConfig;
import io.helidon.metrics.api.MetricsFactory;
import io.helidon.metrics.api.SystemTagsManager;
import io.helidon.metrics.api.Timer;
import io.helidon.metrics.spi.MetersProvider;
import io.helidon.spi.HelidonShutdownHandler;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordingStream;

public class VThreadSystemMetersProvider
implements MetersProvider,
HelidonShutdownHandler,
Resumable {
    static final String METER_NAME_PREFIX = "vthreads.";
    static final String COUNT = "count";
    static final String SUBMIT_FAILURES = "submitFailures";
    static final String PINNED = "pinned";
    static final String RECENT_PINNED = "recentPinned";
    static final String STARTS = "starts";
    private static final String METER_SCOPE = "base";
    private static final System.Logger LOGGER = System.getLogger(VThreadSystemMetersProvider.class.getName());
    private final LazyValue<Timer> recentPinnedVirtualThreads = LazyValue.create(this::findPinned);
    private long virtualThreadSubmitFails;
    private long pinnedVirtualThreads;
    private long virtualThreads;
    private long virtualThreadStarts;
    private long pinnedVirtualThreadsThresholdMillis;
    private RecordingStream recordingStream;
    private MetricsConfig metricsConfig;

    public Collection<Meter.Builder<?, ?>> meterBuilders(MetricsFactory metricsFactory) {
        this.metricsConfig = metricsFactory.metricsConfig();
        if (!this.metricsConfig.virtualThreadsEnabled()) {
            return List.of();
        }
        Main.addShutdownHandler((HelidonShutdownHandler)this);
        ResumableSupport.get().register((Resumable)this);
        this.pinnedVirtualThreadsThresholdMillis = this.metricsConfig.virtualThreadsPinnedThreshold().toMillis();
        ArrayList meterBuilders = new ArrayList(List.of(((Gauge.Builder)Gauge.builder((String)"vthreads.submitFailures", () -> this.virtualThreadSubmitFails).description("Virtual thread submit failures")).scope(METER_SCOPE), ((Gauge.Builder)Gauge.builder((String)"vthreads.pinned", () -> this.pinnedVirtualThreads).description("Number of pinned virtual threads")).scope(METER_SCOPE), ((Timer.Builder)Timer.builder((String)"vthreads.recentPinned").description("Pinned virtual thread durations")).scope(METER_SCOPE), ((Gauge.Builder)Gauge.builder((String)"vthreads.count", () -> this.virtualThreads).description("Active virtual threads")).scope(METER_SCOPE), ((Gauge.Builder)Gauge.builder((String)"vthreads.starts", () -> this.virtualThreadStarts).description("Number of virtual thread starts")).scope(METER_SCOPE)));
        this.startRecordingStream();
        return meterBuilders;
    }

    public void shutdown() {
        if (this.recordingStream != null) {
            this.stopRecordingStream();
        }
    }

    public void suspend() {
        this.shutdown();
    }

    public void resume() {
        this.startRecordingStream();
    }

    long pinnedVirtualThreadsThresholdMillis() {
        return this.pinnedVirtualThreadsThresholdMillis;
    }

    private void startRecordingStream() {
        this.recordingStream = new RecordingStream();
        this.recordingStream.setSettings(Map.of("jdk.VirtualThreadPinned#threshold", this.pinnedVirtualThreadsThresholdMillis + " ms"));
        VThreadSystemMetersProvider.listenFor(this.recordingStream, Map.of("jdk.VirtualThreadSubmitFailed", this::recordSubmitFail, "jdk.VirtualThreadPinned", this::recordThreadPin, "jdk.VirtualThreadStart", this::recordThreadStart, "jdk.VirtualThreadEnd", this::recordThreadEnd));
        this.recordingStream.startAsync();
    }

    private void stopRecordingStream() {
        try {
            LOGGER.log(System.Logger.Level.INFO, "Stopping recording stream");
            this.recordingStream.close();
            this.recordingStream.awaitTermination(Duration.ofSeconds(10L));
            this.recordingStream = null;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static void listenFor(RecordingStream rs, Map<String, Consumer<RecordedEvent>> events) {
        events.forEach((eventName, callback) -> {
            rs.enable((String)eventName);
            rs.onEvent((String)eventName, (Consumer<RecordedEvent>)callback);
        });
    }

    Timer findPinned() {
        Optional result = Metrics.globalRegistry().timer("vthreads.recentPinned", SystemTagsManager.instance().withScopeTag(Collections.emptyList(), Optional.of(METER_SCOPE)));
        if (result.isEmpty()) {
            throw new IllegalStateException("vthreads.recentPinned meter expected but not registered");
        }
        return (Timer)result.get();
    }

    private void recordThreadStart(RecordedEvent event) {
        ++this.virtualThreads;
        ++this.virtualThreadStarts;
        if (this.virtualThreadStarts < 0L) {
            LOGGER.log(System.Logger.Level.INFO, "Metrics counter for virtual thread starts has overflowed; clearing and continuing");
            this.virtualThreadStarts = 0L;
        }
    }

    private void recordThreadEnd(RecordedEvent event) {
        --this.virtualThreads;
    }

    private void recordSubmitFail(RecordedEvent event) {
        ++this.virtualThreadSubmitFails;
    }

    private void recordThreadPin(RecordedEvent event) {
        ++this.pinnedVirtualThreads;
        ((Timer)this.recentPinnedVirtualThreads.get()).record(event.getDuration());
    }
}

