/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.shaded.glassfish.jersey.media.multipart.internal;

import fish.payara.arquillian.shaded.glassfish.jersey.media.multipart.BodyPart;
import fish.payara.arquillian.shaded.glassfish.jersey.media.multipart.BodyPartEntity;
import fish.payara.arquillian.shaded.glassfish.jersey.media.multipart.FormDataBodyPart;
import fish.payara.arquillian.shaded.glassfish.jersey.media.multipart.FormDataMultiPart;
import fish.payara.arquillian.shaded.glassfish.jersey.media.multipart.MultiPart;
import fish.payara.arquillian.shaded.glassfish.jersey.media.multipart.MultiPartProperties;
import fish.payara.arquillian.shaded.glassfish.jersey.media.multipart.internal.LocalizationMessages;
import fish.payara.arquillian.shaded.glassfish.jersey.message.MessageBodyWorkers;
import fish.payara.arquillian.shaded.glassfish.jersey.message.internal.MediaTypes;
import fish.payara.arquillian.shaded.jakarta.inject.Inject;
import fish.payara.arquillian.shaded.jakarta.inject.Provider;
import fish.payara.arquillian.shaded.jakarta.inject.Singleton;
import fish.payara.arquillian.shaded.jakarta.ws.rs.BadRequestException;
import fish.payara.arquillian.shaded.jakarta.ws.rs.ConstrainedTo;
import fish.payara.arquillian.shaded.jakarta.ws.rs.Consumes;
import fish.payara.arquillian.shaded.jakarta.ws.rs.RuntimeType;
import fish.payara.arquillian.shaded.jakarta.ws.rs.WebApplicationException;
import fish.payara.arquillian.shaded.jakarta.ws.rs.core.Context;
import fish.payara.arquillian.shaded.jakarta.ws.rs.core.MediaType;
import fish.payara.arquillian.shaded.jakarta.ws.rs.core.MultivaluedMap;
import fish.payara.arquillian.shaded.jakarta.ws.rs.ext.ContextResolver;
import fish.payara.arquillian.shaded.jakarta.ws.rs.ext.MessageBodyReader;
import fish.payara.arquillian.shaded.jakarta.ws.rs.ext.Providers;
import fish.payara.arquillian.shaded.jvnet.mimepull.Header;
import fish.payara.arquillian.shaded.jvnet.mimepull.MIMEConfig;
import fish.payara.arquillian.shaded.jvnet.mimepull.MIMEMessage;
import fish.payara.arquillian.shaded.jvnet.mimepull.MIMEParsingException;
import fish.payara.arquillian.shaded.jvnet.mimepull.MIMEPart;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@Consumes(value={"multipart/*"})
@Singleton
@ConstrainedTo(value=RuntimeType.CLIENT)
public class MultiPartReaderClientSide
implements MessageBodyReader<MultiPart> {
    private static final Logger LOGGER = Logger.getLogger(MultiPartReaderClientSide.class.getName());
    @Inject
    private Provider<MessageBodyWorkers> messageBodyWorkers;
    private final MIMEConfig mimeConfig;

    public MultiPartReaderClientSide(@Context Providers providers) {
        ContextResolver<MultiPartProperties> contextResolver = providers.getContextResolver(MultiPartProperties.class, MediaType.WILDCARD_TYPE);
        MultiPartProperties properties = null;
        if (contextResolver != null) {
            properties = contextResolver.getContext(this.getClass());
        }
        if (properties == null) {
            properties = new MultiPartProperties();
        }
        this.mimeConfig = this.createMimeConfig(properties);
    }

    private MIMEConfig createMimeConfig(MultiPartProperties properties) {
        MIMEConfig mimeConfig = new MIMEConfig();
        mimeConfig.setMemoryThreshold(properties.getBufferThreshold());
        String tempDir = properties.getTempDir();
        if (tempDir != null) {
            mimeConfig.setDir(tempDir);
        }
        if (properties.getBufferThreshold() != -1) {
            try {
                File.createTempFile("MIME", null, tempDir != null ? new File(tempDir) : null).delete();
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, LocalizationMessages.TEMP_FILE_CANNOT_BE_CREATED(properties.getBufferThreshold()), ioe);
            }
        }
        return mimeConfig;
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return MultiPart.class.isAssignableFrom(type);
    }

    @Override
    public MultiPart readFrom(Class<MultiPart> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream stream) throws IOException, WebApplicationException {
        try {
            return this.readMultiPart(type, genericType, annotations, mediaType, headers, stream);
        }
        catch (MIMEParsingException mpe) {
            if (mpe.getCause() instanceof IOException) {
                throw (IOException)mpe.getCause();
            }
            throw new BadRequestException(mpe);
        }
    }

    protected MultiPart readMultiPart(Class<MultiPart> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream stream) throws IOException, MIMEParsingException {
        boolean fileNameFix;
        mediaType = MultiPartReaderClientSide.unquoteMediaTypeParameters(mediaType, "boundary");
        MIMEMessage mimeMessage = new MIMEMessage(stream, mediaType.getParameters().get("boundary"), this.mimeConfig);
        boolean formData = MediaTypes.typeEqual(mediaType, MediaType.MULTIPART_FORM_DATA_TYPE);
        MultiPart multiPart = formData ? new FormDataMultiPart() : new MultiPart();
        MessageBodyWorkers workers = this.messageBodyWorkers.get();
        multiPart.setMessageBodyWorkers(workers);
        MultivaluedMap<String, String> multiPartHeaders = multiPart.getHeaders();
        for (Map.Entry entry : headers.entrySet()) {
            List values = (List)entry.getValue();
            for (Object value : values) {
                multiPartHeaders.add((String)entry.getKey(), (String)value);
            }
        }
        if (!formData) {
            multiPart.setMediaType(mediaType);
            fileNameFix = false;
        } else {
            String userAgent = headers.getFirst("User-Agent");
            fileNameFix = userAgent != null && userAgent.contains(" MSIE ");
        }
        for (MIMEPart mimePart : this.getMimeParts(mimeMessage)) {
            BodyPart bodyPart = formData ? new FormDataBodyPart(fileNameFix) : new BodyPart();
            bodyPart.setMessageBodyWorkers(workers);
            for (Header header : mimePart.getAllHeaders()) {
                bodyPart.getHeaders().add(header.getName(), header.getValue());
            }
            try {
                String contentType = bodyPart.getHeaders().getFirst("Content-Type");
                if (contentType != null) {
                    bodyPart.setMediaType(MediaType.valueOf(contentType));
                }
                bodyPart.getContentDisposition();
            }
            catch (IllegalArgumentException ex) {
                throw new BadRequestException(ex);
            }
            bodyPart.setEntity(new BodyPartEntity(mimePart));
            multiPart.getBodyParts().add(bodyPart);
        }
        return multiPart;
    }

    private List<MIMEPart> getMimeParts(MIMEMessage message) {
        try {
            return message.getAttachments();
        }
        catch (MIMEParsingException obtainPartsError) {
            LOGGER.log(Level.FINE, LocalizationMessages.PARSING_ERROR(), obtainPartsError);
            message.close();
            throw obtainPartsError;
        }
    }

    private static MediaType unquoteMediaTypeParameters(MediaType mediaType, String ... parameters) {
        if (parameters == null || parameters.length == 0) {
            return mediaType;
        }
        HashMap<String, String> unquotedParams = new HashMap<String, String>(mediaType.getParameters());
        for (String parameter : parameters) {
            String value = mediaType.getParameters().get(parameter);
            if (value == null || !value.startsWith("\"")) continue;
            value = value.substring(1, value.length() - 1);
            unquotedParams.put(parameter, value);
        }
        return new MediaType(mediaType.getType(), mediaType.getSubtype(), unquotedParams);
    }
}

