/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.shaded.glassfish.json;

import fish.payara.arquillian.shaded.glassfish.json.JsonArrayBuilderImpl;
import fish.payara.arquillian.shaded.glassfish.json.JsonObjectBuilderImpl;
import fish.payara.arquillian.shaded.glassfish.json.api.BufferPool;
import fish.payara.arquillian.shaded.jakarta.json.JsonArray;
import fish.payara.arquillian.shaded.jakarta.json.JsonArrayBuilder;
import fish.payara.arquillian.shaded.jakarta.json.JsonBuilderFactory;
import fish.payara.arquillian.shaded.jakarta.json.JsonObject;
import fish.payara.arquillian.shaded.jakarta.json.JsonObjectBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

class JsonBuilderFactoryImpl
implements JsonBuilderFactory {
    private final Map<String, ?> config = Collections.emptyMap();
    private final BufferPool bufferPool;

    JsonBuilderFactoryImpl(BufferPool bufferPool) {
        this.bufferPool = bufferPool;
    }

    @Override
    public JsonObjectBuilder createObjectBuilder() {
        return new JsonObjectBuilderImpl(this.bufferPool);
    }

    @Override
    public JsonObjectBuilder createObjectBuilder(JsonObject object) {
        return new JsonObjectBuilderImpl(object, this.bufferPool);
    }

    @Override
    public JsonObjectBuilder createObjectBuilder(Map<String, Object> object) {
        return new JsonObjectBuilderImpl(object, this.bufferPool);
    }

    @Override
    public JsonArrayBuilder createArrayBuilder() {
        return new JsonArrayBuilderImpl(this.bufferPool);
    }

    @Override
    public JsonArrayBuilder createArrayBuilder(JsonArray array) {
        return new JsonArrayBuilderImpl(array, this.bufferPool);
    }

    @Override
    public JsonArrayBuilder createArrayBuilder(Collection<?> collection) {
        return new JsonArrayBuilderImpl(collection, this.bufferPool);
    }

    @Override
    public Map<String, ?> getConfigInUse() {
        return this.config;
    }
}

