/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.client;

import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import javax.net.ssl.TrustManagerFactory;
import scala.MatchError;
import zio.http.ClientSSLConfig;
import zio.http.ClientSSLConfig$Default$;

public final class ClientSSLConverter$ {
    public static ClientSSLConverter$ MODULE$;

    static {
        new ClientSSLConverter$();
    }

    private SslContext trustStoreToSslContext(InputStream trustStoreStream, String trustStorePassword) {
        KeyStore trustStore = KeyStore.getInstance("JKS");
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustStore.load(trustStoreStream, trustStorePassword.toCharArray());
        trustManagerFactory.init(trustStore);
        return SslContextBuilder.forClient().trustManager(trustManagerFactory).build();
    }

    private SslContext certToSslContext(InputStream certStream) {
        return SslContextBuilder.forClient().trustManager(certStream).build();
    }

    public SslContext toNettySSLContext(ClientSSLConfig sslConfig) {
        if (ClientSSLConfig$Default$.MODULE$.equals(sslConfig)) {
            return SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
        }
        if (sslConfig instanceof ClientSSLConfig.FromCertFile) {
            String certPath = ((ClientSSLConfig.FromCertFile)sslConfig).certPath();
            FileInputStream certStream = new FileInputStream(certPath);
            return this.certToSslContext(certStream);
        }
        if (sslConfig instanceof ClientSSLConfig.FromCertResource) {
            String certPath = ((ClientSSLConfig.FromCertResource)sslConfig).certPath();
            InputStream certStream = this.getClass().getClassLoader().getResourceAsStream(certPath);
            return this.certToSslContext(certStream);
        }
        if (sslConfig instanceof ClientSSLConfig.FromTrustStoreFile) {
            ClientSSLConfig.FromTrustStoreFile fromTrustStoreFile = (ClientSSLConfig.FromTrustStoreFile)sslConfig;
            String trustStorePath = fromTrustStoreFile.trustStorePath();
            String trustStorePassword = fromTrustStoreFile.trustStorePassword();
            FileInputStream trustStoreStream = new FileInputStream(trustStorePath);
            return this.trustStoreToSslContext(trustStoreStream, trustStorePassword);
        }
        if (sslConfig instanceof ClientSSLConfig.FromTrustStoreResource) {
            ClientSSLConfig.FromTrustStoreResource fromTrustStoreResource = (ClientSSLConfig.FromTrustStoreResource)sslConfig;
            String trustStorePath = fromTrustStoreResource.trustStorePath();
            String trustStorePassword = fromTrustStoreResource.trustStorePassword();
            InputStream trustStoreStream = this.getClass().getClassLoader().getResourceAsStream(trustStorePath);
            return this.trustStoreToSslContext(trustStoreStream, trustStorePassword);
        }
        throw new MatchError((Object)sslConfig);
    }

    private ClientSSLConverter$() {
        MODULE$ = this;
    }
}

