/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.AsciiString;
import java.io.File;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Some;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import zio.Chunk;
import zio.ZIO;
import zio.ZIO$;
import zio.http.Body;
import zio.http.Body$EmptyBody$;
import zio.http.netty.NettyBody;
import zio.http.netty.NettyFutureExecutor$;

public final class NettyBodyWriter$ {
    public static NettyBodyWriter$ MODULE$;

    static {
        new NettyBodyWriter$();
    }

    public ZIO<Object, Throwable, Object> write(Body body, ChannelHandlerContext ctx) {
        if (body instanceof NettyBody.ByteBufBody) {
            NettyBody.ByteBufBody byteBufBody = (NettyBody.ByteBufBody)body;
            return ZIO$.MODULE$.succeed((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                ctx.write((Object)byteBufBody.byteBuf());
                return false;
            }, (Object)"zio.http.netty.NettyBodyWriter.write(NettyBodyWriter.scala:35)");
        }
        if (body instanceof Body.FileBody) {
            Body.FileBody fileBody = (Body.FileBody)body;
            return ZIO$.MODULE$.succeed((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                File file = fileBody.file();
                ctx.write((Object)new DefaultFileRegion(file, 0L, file.length()));
                ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
                return true;
            }, (Object)"zio.http.netty.NettyBodyWriter.write(NettyBodyWriter.scala:40)");
        }
        if (body instanceof NettyBody.AsyncBody) {
            Function1<NettyBody.UnsafeAsync, BoxedUnit> async = ((NettyBody.AsyncBody)body).unsafeAsync();
            return ZIO$.MODULE$.attempt((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                async.apply((Object)new NettyBody.UnsafeAsync(ctx){
                    private final ChannelHandlerContext ctx$1;

                    public void apply(Chunk<Object> message, boolean isLast) {
                        if (!(message instanceof Chunk.ByteArray)) {
                            throw new IllegalStateException(new StringBuilder(28).append("Unsupported async msg type: ").append(message.getClass()).toString());
                        }
                        ByteBuf nettyMsg = Unpooled.wrappedBuffer((byte[])((Chunk.ByteArray)message).array());
                        this.ctx$1.writeAndFlush((Object)nettyMsg);
                        if (isLast) {
                            this.ctx$1.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
                            return;
                        }
                    }

                    public void fail(Throwable cause) {
                        this.ctx$1.fireExceptionCaught(cause);
                    }
                    {
                        this.ctx$1 = ctx$1;
                    }
                });
                return true;
            }, (Object)"zio.http.netty.NettyBodyWriter.write(NettyBodyWriter.scala:50)");
        }
        if (body instanceof NettyBody.AsciiStringBody) {
            AsciiString asciiString = ((NettyBody.AsciiStringBody)body).asciiString();
            return ZIO$.MODULE$.attempt((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                ctx.write((Object)Unpooled.wrappedBuffer((byte[])asciiString.array()));
                return false;
            }, (Object)"zio.http.netty.NettyBodyWriter.write(NettyBodyWriter.scala:69)");
        }
        if (body instanceof Body.StreamBody) {
            return ((Body.StreamBody)body).stream().chunks((Object)"zio.http.netty.NettyBodyWriter.write(NettyBodyWriter.scala:74)").runFoldZIO((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                if (x0$1 instanceof Some) {
                    Chunk previous = (Chunk)((Some)x0$1).value();
                    return NettyFutureExecutor$.MODULE$.executed((Function0 & Serializable & scala.Serializable)() -> ctx.writeAndFlush((Object)new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])((byte[])previous.toArray(ClassTag$.MODULE$.Byte()))))), "zio.http.netty.NettyBodyWriter.write(NettyBodyWriter.scala:77)").$times$greater((Function0 & Serializable & scala.Serializable)() -> ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> new Some(x1$1), (Object)"zio.http.netty.NettyBodyWriter.write(NettyBodyWriter.scala:80)"), (Object)"zio.http.netty.NettyBodyWriter.write(NettyBodyWriter.scala:79)");
                }
                return ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> new Some(x1$1), (Object)"zio.http.netty.NettyBodyWriter.write(NettyBodyWriter.scala:82)");
            }, (Object)"zio.http.netty.NettyBodyWriter.write(NettyBodyWriter.scala:75)").flatMap((Function1 & Serializable & scala.Serializable)maybeLastChunk -> ZIO$.MODULE$.attempt((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> maybeLastChunk.foreach((Function1 & Serializable & scala.Serializable)lastChunk -> ctx.write((Object)new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])((byte[])lastChunk.toArray(ClassTag$.MODULE$.Byte())))))), (Object)"zio.http.netty.NettyBodyWriter.write(NettyBodyWriter.scala:86)").$times$greater((Function0 & Serializable & scala.Serializable)() -> NettyFutureExecutor$.MODULE$.executed((Function0 & Serializable & scala.Serializable)() -> ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT), "zio.http.netty.NettyBodyWriter.write(NettyBodyWriter.scala:91)").as((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true, (Object)"zio.http.netty.NettyBodyWriter.write(NettyBodyWriter.scala:93)"), (Object)"zio.http.netty.NettyBodyWriter.write(NettyBodyWriter.scala:90)"), (Object)"zio.http.netty.NettyBodyWriter.write(NettyBodyWriter.scala:84)");
        }
        if (body instanceof Body.ChunkBody) {
            Chunk<Object> data = ((Body.ChunkBody)body).data();
            return ZIO$.MODULE$.succeed((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                ctx.write((Object)Unpooled.wrappedBuffer((byte[])((byte[])data.toArray(ClassTag$.MODULE$.Byte()))));
                return false;
            }, (Object)"zio.http.netty.NettyBodyWriter.write(NettyBodyWriter.scala:96)");
        }
        if (Body$EmptyBody$.MODULE$.equals(body)) {
            return ZIO$.MODULE$.succeed((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, (Object)"zio.http.netty.NettyBodyWriter.write(NettyBodyWriter.scala:100)");
        }
        throw new MatchError((Object)body);
    }

    private NettyBodyWriter$() {
        MODULE$ = this;
    }
}

