/*
 * Decompiled with CFR 0.152.
 */
package zio.http;

import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.runtime.Nothing$;
import zio.ZEnvironment;
import zio.ZIO;
import zio.ZIO$;
import zio.http.Body;
import zio.http.Body$;
import zio.http.Channel;
import zio.http.ChannelEvent;
import zio.http.Handler;
import zio.http.Header;
import zio.http.Header$ContentType$;
import zio.http.Headers;
import zio.http.Headers$;
import zio.http.HttpError;
import zio.http.MediaType$;
import zio.http.Response;
import zio.http.ServerSentEvent;
import zio.http.Status;
import zio.http.Status$Ok$;
import zio.http.Status$PermanentRedirect$;
import zio.http.Status$SeeOther$;
import zio.http.Status$SwitchingProtocols$;
import zio.http.Status$TemporaryRedirect$;
import zio.http.URL;
import zio.http.WebSocketFrame;
import zio.http.html.Html;
import zio.stream.ZStream;

public final class Response$ {
    public static Response$ MODULE$;
    private Headers contentTypeJson;
    private Headers contentTypeHtml;
    private Headers contentTypeText;
    private Headers contentTypeEventStream;
    private volatile byte bitmap$0;
    private volatile byte bitmap$init$0;

    static {
        new Response$();
    }

    public Response apply(Status status, Headers headers, Body body) {
        return new Response.BasicResponse(body, headers, status);
    }

    public Status apply$default$1() {
        return Status$Ok$.MODULE$;
    }

    public Headers apply$default$2() {
        return Headers$.MODULE$.empty();
    }

    public Body apply$default$3() {
        return Body$.MODULE$.empty();
    }

    public Response fromHttpError(HttpError error) {
        return new Response.ErrorResponse(Body$.MODULE$.empty(), Headers$.MODULE$.empty(), error, error.status());
    }

    public <R> ZIO<R, Nothing$, Response> fromSocket(Handler<R, Throwable, Channel<ChannelEvent<WebSocketFrame>, ChannelEvent<WebSocketFrame>>, Object> http, Object trace) {
        return this.fromSocketApp(http, trace);
    }

    public <R> ZIO<R, Nothing$, Response> fromSocketApp(Handler<R, Throwable, Channel<ChannelEvent<WebSocketFrame>, ChannelEvent<WebSocketFrame>>, Object> app, Object trace) {
        return ZIO$.MODULE$.environment(trace).map((Function1 & Serializable & scala.Serializable)env -> new Response.SocketAppResponse(Body$.MODULE$.empty(), Headers$.MODULE$.empty(), app.provideEnvironment((ZEnvironment)env, trace), Status$SwitchingProtocols$.MODULE$), trace);
    }

    public Response html(Html data, Status status) {
        return new Response.BasicResponse(Body$.MODULE$.fromString(new StringBuilder(15).append("<!DOCTYPE html>").append(data.encode()).toString(), Body$.MODULE$.fromString$default$2()), this.contentTypeHtml(), status);
    }

    public Status html$default$2() {
        return Status$Ok$.MODULE$;
    }

    public Response json(CharSequence data) {
        return new Response.BasicResponse(Body$.MODULE$.fromCharSequence(data, Body$.MODULE$.fromCharSequence$default$2()), this.contentTypeJson(), Status$Ok$.MODULE$);
    }

    public Response ok() {
        return new Response.BasicResponse(Body$.MODULE$.empty(), Headers$.MODULE$.empty(), Status$Ok$.MODULE$);
    }

    public Response redirect(URL location, boolean isPermanent) {
        Status status = isPermanent ? Status$PermanentRedirect$.MODULE$ : Status$TemporaryRedirect$.MODULE$;
        return new Response.BasicResponse(Body$.MODULE$.empty(), Headers$.MODULE$.apply((Seq<Header>)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{new Header.Location(location)})), status);
    }

    public boolean redirect$default$2() {
        return false;
    }

    public Response seeOther(URL location) {
        return new Response.BasicResponse(Body$.MODULE$.empty(), Headers$.MODULE$.apply((Seq<Header>)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{new Header.Location(location)})), Status$SeeOther$.MODULE$);
    }

    public Response status(Status status) {
        return new Response.BasicResponse(Body$.MODULE$.empty(), Headers$.MODULE$.empty(), status);
    }

    public Response text(CharSequence text) {
        return new Response.BasicResponse(Body$.MODULE$.fromCharSequence(text, Body$.MODULE$.fromCharSequence$default$2()), this.contentTypeText(), Status$Ok$.MODULE$);
    }

    public Response fromServerSentEvents(ZStream<Object, Nothing$, ServerSentEvent> data) {
        return new Response.BasicResponse(Body$.MODULE$.fromStream((ZStream<Object, Throwable, CharSequence>)data.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.encode(), (Object)"zio.http.Response.fromServerSentEvents(Response.scala:415)"), Body$.MODULE$.fromStream$default$2(), "zio.http.Response.fromServerSentEvents(Response.scala:415)"), this.contentTypeEventStream(), Status$Ok$.MODULE$);
    }

    private Headers contentTypeJson$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.contentTypeJson = Headers$.MODULE$.apply((Seq<Header>)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{new Header.ContentType(MediaType$.MODULE$.application().json(), Header$ContentType$.MODULE$.apply$default$2(), Header$ContentType$.MODULE$.apply$default$3()).untyped()}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.contentTypeJson;
    }

    private Headers contentTypeJson() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.contentTypeJson$lzycompute();
        }
        return this.contentTypeJson;
    }

    private Headers contentTypeHtml$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.contentTypeHtml = Headers$.MODULE$.apply((Seq<Header>)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{new Header.ContentType(MediaType$.MODULE$.text().html(), Header$ContentType$.MODULE$.apply$default$2(), Header$ContentType$.MODULE$.apply$default$3()).untyped()}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.contentTypeHtml;
    }

    private Headers contentTypeHtml() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.contentTypeHtml$lzycompute();
        }
        return this.contentTypeHtml;
    }

    private Headers contentTypeText$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.contentTypeText = Headers$.MODULE$.apply((Seq<Header>)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{new Header.ContentType(MediaType$.MODULE$.text().plain(), Header$ContentType$.MODULE$.apply$default$2(), Header$ContentType$.MODULE$.apply$default$3()).untyped()}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.contentTypeText;
    }

    private Headers contentTypeText() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.contentTypeText$lzycompute();
        }
        return this.contentTypeText;
    }

    private Headers contentTypeEventStream$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.contentTypeEventStream = Headers$.MODULE$.apply((Seq<Header>)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{new Header.ContentType(MediaType$.MODULE$.text().event$minusstream(), Header$ContentType$.MODULE$.apply$default$2(), Header$ContentType$.MODULE$.apply$default$3()).untyped()}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.contentTypeEventStream;
    }

    private Headers contentTypeEventStream() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.contentTypeEventStream$lzycompute();
        }
        return this.contentTypeEventStream;
    }

    private Response$() {
        MODULE$ = this;
    }
}

