/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.invocation;

import dev.langchain4j.invocation.InvocationContext;
import dev.langchain4j.invocation.InvocationParameters;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class DefaultInvocationContext
implements InvocationContext {
    private final UUID invocationId;
    private final String interfaceName;
    private final String methodName;
    private final List<Object> methodArguments = new ArrayList<Object>();
    private final Object chatMemoryId;
    private final InvocationParameters invocationParameters;
    private final Instant timestamp;

    public DefaultInvocationContext(InvocationContext.Builder builder) {
        this.invocationId = builder.invocationId();
        this.interfaceName = builder.interfaceName();
        this.methodName = builder.methodName();
        this.methodArguments.addAll(builder.methodArguments());
        this.chatMemoryId = builder.chatMemoryId();
        this.invocationParameters = builder.invocationParameters();
        this.timestamp = builder.timestamp();
    }

    @Override
    public UUID invocationId() {
        return this.invocationId;
    }

    @Override
    public String interfaceName() {
        return this.interfaceName;
    }

    @Override
    public String methodName() {
        return this.methodName;
    }

    @Override
    public List<Object> methodArguments() {
        return this.methodArguments;
    }

    @Override
    public Object chatMemoryId() {
        return this.chatMemoryId;
    }

    @Override
    public InvocationParameters invocationParameters() {
        return this.invocationParameters;
    }

    @Override
    public Instant timestamp() {
        return this.timestamp;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DefaultInvocationContext that = (DefaultInvocationContext)object;
        return Objects.equals(this.invocationId, that.invocationId) && Objects.equals(this.interfaceName, that.interfaceName) && Objects.equals(this.methodName, that.methodName) && Objects.equals(this.methodArguments, that.methodArguments) && Objects.equals(this.chatMemoryId, that.chatMemoryId) && Objects.equals(this.invocationParameters, that.invocationParameters) && Objects.equals(this.timestamp, that.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.invocationId, this.interfaceName, this.methodName, this.methodArguments, this.chatMemoryId, this.invocationParameters, this.timestamp);
    }

    public String toString() {
        return "DefaultInvocationContext{invocationId=" + String.valueOf(this.invocationId) + ", interfaceName='" + this.interfaceName + "', methodName='" + this.methodName + "', methodArguments=" + String.valueOf(this.methodArguments) + ", chatMemoryId=" + String.valueOf(this.chatMemoryId) + ", invocationParameters=" + String.valueOf(this.invocationParameters) + ", timestamp=" + String.valueOf(this.timestamp) + "}";
    }
}

