/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua.checkers.utils.tables;

import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.element.Table;
import com.itextpdf.pdfua.checkers.utils.PdfUAValidationContext;
import com.itextpdf.pdfua.checkers.utils.tables.ITableIterator;
import java.util.List;

final class TableCellIterator
implements ITableIterator<Cell> {
    final PdfUAValidationContext context;
    private List<IElement> children;
    private int index;
    private TableCellIterator headerIterator;
    private TableCellIterator footerIterator;
    private Table table;
    private PdfName location;
    private Cell currentCell;

    public TableCellIterator(Table table, PdfUAValidationContext context) {
        this.context = context;
        if (table == null) {
            return;
        }
        this.table = table;
        this.children = table.getChildren();
        this.headerIterator = new TableCellIterator(table.getHeader(), context);
        this.footerIterator = new TableCellIterator(table.getFooter(), context);
    }

    @Override
    public boolean hasNext() {
        if (this.headerIterator != null && this.headerIterator.hasNext()) {
            return true;
        }
        if (this.children != null && this.index < this.children.size()) {
            return true;
        }
        return this.footerIterator != null && this.footerIterator.hasNext();
    }

    @Override
    public Cell next() {
        if (this.headerIterator != null && this.headerIterator.hasNext()) {
            this.location = PdfName.THead;
            this.currentCell = this.headerIterator.next();
            return this.currentCell;
        }
        if (this.children != null && this.index < this.children.size()) {
            this.location = PdfName.TBody;
            this.currentCell = (Cell)this.children.get(this.index++);
            return this.currentCell;
        }
        if (this.footerIterator != null && this.footerIterator.hasNext()) {
            this.location = PdfName.TFoot;
            this.currentCell = this.footerIterator.next();
            return this.currentCell;
        }
        return null;
    }

    @Override
    public int getAmountOfRowsBody() {
        return this.table.getNumberOfRows();
    }

    @Override
    public int getAmountOfRowsHeader() {
        if (this.table.getHeader() != null) {
            return this.table.getHeader().getNumberOfRows();
        }
        return 0;
    }

    @Override
    public int getAmountOfRowsFooter() {
        if (this.table.getFooter() != null) {
            return this.table.getFooter().getNumberOfRows();
        }
        return 0;
    }

    @Override
    public int getNumberOfColumns() {
        return this.table.getNumberOfColumns();
    }

    @Override
    public int getRow() {
        PdfName location = this.getLocation();
        int row = this.currentCell.getRow();
        if (location == PdfName.TBody) {
            row += this.getAmountOfRowsHeader();
        }
        if (location == PdfName.TFoot) {
            row += this.getAmountOfRowsHeader();
            row += this.getAmountOfRowsBody();
        }
        return row;
    }

    @Override
    public int getCol() {
        return this.currentCell.getCol();
    }

    @Override
    public int getRowspan() {
        return this.currentCell.getRowspan();
    }

    @Override
    public int getColspan() {
        return this.currentCell.getColspan();
    }

    private PdfName getLocation() {
        return this.location;
    }
}

