/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua.checkers.utils;

import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.tagging.IStructureNode;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.kernel.pdf.tagutils.AccessibilityProperties;
import com.itextpdf.kernel.pdf.tagutils.ITagTreeIteratorHandler;
import com.itextpdf.layout.element.Image;
import com.itextpdf.pdfua.checkers.utils.ContextAwareTagTreeIteratorHandler;
import com.itextpdf.pdfua.checkers.utils.PdfUAValidationContext;
import com.itextpdf.pdfua.exceptions.PdfUAConformanceException;

public final class GraphicsCheckUtil {
    private final PdfUAValidationContext context;

    public GraphicsCheckUtil(PdfUAValidationContext context) {
        this.context = context;
    }

    @Deprecated
    public static void checkLayoutImage(Image image) {
    }

    @Deprecated
    public static ITagTreeIteratorHandler createFigureTagHandler() {
        return null;
    }

    public void checkLayoutElement(Image image) {
        if (image.getAccessibilityProperties() == null) {
            throw new IllegalStateException();
        }
        if (!"Figure".equals(this.context.resolveToStandardRole(image.getAccessibilityProperties().getRole()))) {
            return;
        }
        AccessibilityProperties props = image.getAccessibilityProperties();
        boolean hasSomeValue = GraphicsCheckUtil.hasAtleastOneValidValue(props.getAlternateDescription(), props.getActualText());
        if (!hasSomeValue) {
            throw new PdfUAConformanceException("Figure tags shall include an alternative representation or replacement text. call com.itextpdf.kernel.pdf.tagutils.AccessibilityProperties#setActualText or com.itextpdf.kernel.pdf.tagutils.AccessibilityProperties#setAlternateDescription to be PDF/UA compliant.");
        }
    }

    private static boolean hasAtleastOneValidValue(Object altText, Object actualText) {
        String altTextValue = null;
        if (altText instanceof PdfString) {
            altTextValue = ((PdfString)altText).getValue();
        }
        String actualTextValue = null;
        if (actualText instanceof PdfString) {
            actualTextValue = ((PdfString)actualText).getValue();
        }
        if (altText instanceof String) {
            altTextValue = (String)altText;
        }
        if (actualText instanceof String) {
            actualTextValue = (String)actualText;
        }
        return altTextValue != null && !altTextValue.isEmpty() || actualTextValue != null;
    }

    public static class GraphicsHandler
    extends ContextAwareTagTreeIteratorHandler {
        public GraphicsHandler(PdfUAValidationContext context) {
            super(context);
        }

        public void nextElement(IStructureNode elem) {
            PdfStructElem structElem = this.context.getElementIfRoleMatches(PdfName.Figure, elem);
            if (structElem == null) {
                return;
            }
            PdfDictionary pdfObject = (PdfDictionary)structElem.getPdfObject();
            if (!GraphicsCheckUtil.hasAtleastOneValidValue(pdfObject.getAsString(PdfName.Alt), pdfObject.getAsString(PdfName.ActualText))) {
                throw new PdfUAConformanceException("Figure tags shall include an alternative representation or replacement text. call com.itextpdf.kernel.pdf.tagutils.AccessibilityProperties#setActualText or com.itextpdf.kernel.pdf.tagutils.AccessibilityProperties#setAlternateDescription to be PDF/UA compliant.");
            }
        }
    }
}

