/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.textextraction;

import com.ibm.watsonx.ai.textextraction.TextExtractionParameters;
import java.util.Objects;

public final class TextExtractionUtils {
    public static String addExtension(String fileName, TextExtractionParameters.Type extension) {
        Objects.requireNonNull(fileName, "fileName cannot be null");
        Objects.requireNonNull(extension, "extension cannot be null");
        int index = fileName.lastIndexOf(".");
        fileName = index > 0 ? fileName.substring(0, index) : fileName;
        return switch (extension) {
            default -> throw new IncompatibleClassChangeError();
            case TextExtractionParameters.Type.HTML -> fileName.concat(".html");
            case TextExtractionParameters.Type.JSON -> fileName.concat(".json");
            case TextExtractionParameters.Type.MD -> fileName.concat(".md");
            case TextExtractionParameters.Type.PAGE_IMAGES -> fileName;
            case TextExtractionParameters.Type.PLAIN_TEXT -> fileName.concat(".txt");
        };
    }
}

