/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.rerank;

import com.ibm.watsonx.ai.WatsonxService;
import com.ibm.watsonx.ai.core.Json;
import com.ibm.watsonx.ai.rerank.RerankParameters;
import com.ibm.watsonx.ai.rerank.RerankRequest;
import com.ibm.watsonx.ai.rerank.RerankResponse;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class RerankService
extends WatsonxService.ModelService {
    protected RerankService(Builder builder) {
        super(builder);
        Objects.requireNonNull(builder.getAuthenticationProvider(), "authenticationProvider cannot be null");
    }

    public RerankResponse rerank(String query, List<String> inputs) {
        return this.rerank(query, inputs, null);
    }

    public RerankResponse rerank(String query, List<String> inputs, RerankParameters parameters) {
        Objects.requireNonNull(query, "Query cannot be null");
        Objects.requireNonNull(inputs, "Inputs cannot be null");
        String modelId = this.modelId;
        String projectId = this.projectId;
        String spaceId = this.spaceId;
        String transactionId = null;
        RerankRequest.Parameters requestParameters = null;
        if (Objects.nonNull(parameters)) {
            modelId = Objects.requireNonNullElse(parameters.getModelId(), this.modelId);
            projectId = Optional.ofNullable(parameters.getProjectId()).orElse(this.projectId);
            spaceId = Optional.ofNullable(parameters.getSpaceId()).orElse(this.spaceId);
            transactionId = parameters.getTransactionId();
            requestParameters = parameters.toRerankRequestParameters();
        }
        RerankRequest rerankRequest = new RerankRequest(modelId, inputs.stream().map(RerankRequest.RerankInput::new).toList(), query, spaceId, projectId, requestParameters);
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(URI.create(this.url.toString() + "%s/rerank?version=%s".formatted(ML_API_TEXT_PATH, this.version))).header("Content-Type", "application/json").header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(Json.toJson((Object)rerankRequest)));
        if (Objects.nonNull(transactionId)) {
            httpRequest.header("X-Global-Transaction-Id", transactionId);
        }
        try {
            HttpResponse httpReponse = this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString());
            return (RerankResponse)Json.fromJson((String)((String)httpReponse.body()), RerankResponse.class);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends WatsonxService.ModelService.Builder<Builder> {
        private Builder() {
        }

        public RerankService build() {
            return new RerankService(this);
        }
    }
}

