/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveFileWriter;
import com.facebook.presto.hive.OrcFileWriterFactory;
import com.facebook.presto.hive.SortingFileWriter;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PageSorter;
import com.facebook.presto.spi.PrestoException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;

public class SortingFileWriterFactory {
    private final HdfsEnvironment hdfsEnvironment;
    private final ConnectorSession session;
    private final JobConf conf;
    private final List<Type> types;
    private final List<Integer> sortFields;
    private final List<SortOrder> sortOrders;
    private final DataSize sortBufferSize;
    private final int maxOpenSortFiles;
    private final PageSorter pageSorter;
    private final OrcFileWriterFactory orcFileWriterFactory;
    private final boolean sortedWriteToTempPathEnabled;
    private final int sortedWriteTempFileSubdirectoryCount;

    public SortingFileWriterFactory(HdfsEnvironment hdfsEnvironment, ConnectorSession session, JobConf conf, List<Type> types, List<Integer> sortFields, List<SortOrder> sortOrders, DataSize sortBufferSize, int maxOpenSortFiles, PageSorter pageSorter, OrcFileWriterFactory orcFileWriterFactory, boolean sortedWriteToTempPathEnabled, int sortedWriteTempFileSubdirectoryCount) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.conf = Objects.requireNonNull(conf, "conf is null");
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.sortFields = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortFields, "sortFields is null"));
        this.sortOrders = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortOrders, "sortOrders is null"));
        this.sortBufferSize = Objects.requireNonNull(sortBufferSize, "sortBufferSize is null");
        this.maxOpenSortFiles = maxOpenSortFiles;
        this.pageSorter = Objects.requireNonNull(pageSorter, "pageSorter is null");
        this.orcFileWriterFactory = Objects.requireNonNull(orcFileWriterFactory, "orcFileWriterFactory is null");
        this.sortedWriteToTempPathEnabled = sortedWriteToTempPathEnabled;
        this.sortedWriteTempFileSubdirectoryCount = sortedWriteTempFileSubdirectoryCount;
    }

    public SortingFileWriter createSortingFileWriter(Path path, HiveFileWriter outputWriter, int fileNumber, Optional<Path> tempPath) {
        ExtendedFileSystem fileSystem;
        Preconditions.checkState((tempPath.isPresent() == this.sortedWriteToTempPathEnabled ? 1 : 0) != 0, (Object)"tempPath existence is not consistent with sortedWriteToTempPathEnabled config");
        try {
            fileSystem = this.hdfsEnvironment.getFileSystem(this.session.getUser(), path, (Configuration)this.conf);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_OPEN_ERROR, (Throwable)e);
        }
        Path prefix = this.sortedWriteToTempPathEnabled ? new Path(tempPath.get(), String.format(".tmp-sort-%s/.tmp-sort-%s", fileNumber % this.sortedWriteTempFileSubdirectoryCount, path.getName())) : new Path(path.getParent(), ".tmp-sort." + path.getName());
        return new SortingFileWriter((FileSystem)fileSystem, prefix, outputWriter, this.sortBufferSize, this.maxOpenSortFiles, this.types, this.sortFields, this.sortOrders, this.pageSorter, (fs, p) -> this.orcFileWriterFactory.createDataSink(this.session, fs, p), this.sortedWriteToTempPathEnabled);
    }
}

