/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.PartitionObjectBuilder;
import com.facebook.presto.hive.PartitionUpdate;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.ConnectorSession;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class HivePartitionObjectBuilder
implements PartitionObjectBuilder {
    @Override
    public Partition buildPartitionObject(ConnectorSession session, Table table, PartitionUpdate partitionUpdate, String prestoVersion, Map<String, String> extraParameters) {
        ImmutableMap.Builder extraParametersBuilder = ImmutableMap.builder().put((Object)"presto_version", (Object)prestoVersion).put((Object)"presto_query_id", (Object)session.getQueryId()).putAll(extraParameters);
        HiveSessionProperties.getNewPartitionUserSuppliedParameter(session).ifPresent(param -> extraParametersBuilder.put((Object)"user_supplied", param));
        return Partition.builder().setDatabaseName(table.getDatabaseName()).setTableName(table.getTableName()).setColumns(table.getDataColumns()).setValues(MetastoreUtil.extractPartitionValues((String)partitionUpdate.getName())).setParameters((Map)extraParametersBuilder.build()).withStorage(storage -> storage.setStorageFormat(HiveSessionProperties.isRespectTableFormat(session) ? table.getStorage().getStorageFormat() : StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveSessionProperties.getHiveStorageFormat(session))).setLocation(partitionUpdate.getTargetPath().toString()).setBucketProperty(table.getStorage().getBucketProperty()).setSerdeParameters(table.getStorage().getSerdeParameters()).setParameters(table.getStorage().getParameters())).build();
    }
}

