/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.parser;

import com.baomidou.mybatisplus.extension.parser.JsqlParserFunction;
import com.baomidou.mybatisplus.extension.parser.cache.JsqlParseCache;
import com.baomidou.mybatisplus.jsqlparser.JsqlParserThreadPool;
import java.util.concurrent.ExecutorService;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.Statements;

public class JsqlParserGlobal {
    @Deprecated
    public static final int DEFAULT_THREAD_SIZE = (Runtime.getRuntime().availableProcessors() + 1) / 2;
    @Deprecated
    public static ExecutorService executorService;
    private static JsqlParserFunction<String, Statement> parserSingleFunc;
    private static JsqlParserFunction<String, Statements> parserMultiFunc;
    private static JsqlParseCache jsqlParseCache;

    public static void setExecutorService(ExecutorService executorService) {
        JsqlParserGlobal.executorService = executorService;
    }

    @Deprecated
    public static void setExecutorService(ExecutorService executorService, boolean addShutdownHook) {
        JsqlParserGlobal.executorService = executorService;
        if (addShutdownHook) {
            JsqlParserThreadPool.addShutdownHook((ExecutorService)executorService);
        }
    }

    public static void setExecutorService(ExecutorService executorService, Thread shutdownHook) {
        JsqlParserGlobal.executorService = executorService;
        if (shutdownHook != null) {
            Runtime.getRuntime().addShutdownHook(shutdownHook);
        }
    }

    public static ExecutorService getExecutorService() {
        return executorService == null ? JsqlParserThreadPool.getDefaultThreadPoolExecutor() : executorService;
    }

    public static Statement parse(String sql) throws JSQLParserException {
        if (jsqlParseCache == null) {
            return parserSingleFunc.apply(sql);
        }
        Statement statement = jsqlParseCache.getStatement(sql);
        if (statement == null) {
            statement = parserSingleFunc.apply(sql);
            jsqlParseCache.putStatement(sql, statement);
        }
        return statement;
    }

    public static Statements parseStatements(String sql) throws JSQLParserException {
        if (jsqlParseCache == null) {
            return parserMultiFunc.apply(sql);
        }
        Statements statements = jsqlParseCache.getStatements(sql);
        if (statements == null) {
            statements = parserMultiFunc.apply(sql);
            jsqlParseCache.putStatements(sql, statements);
        }
        return statements;
    }

    public static void setParserSingleFunc(JsqlParserFunction<String, Statement> parserSingleFunc) {
        JsqlParserGlobal.parserSingleFunc = parserSingleFunc;
    }

    public static void setParserMultiFunc(JsqlParserFunction<String, Statements> parserMultiFunc) {
        JsqlParserGlobal.parserMultiFunc = parserMultiFunc;
    }

    public static void setJsqlParseCache(JsqlParseCache jsqlParseCache) {
        JsqlParserGlobal.jsqlParseCache = jsqlParseCache;
    }

    static {
        parserSingleFunc = sql -> CCJSqlParserUtil.parse((String)sql, (ExecutorService)JsqlParserGlobal.getExecutorService(), null);
        parserMultiFunc = sql -> CCJSqlParserUtil.parseStatements((String)sql, (ExecutorService)JsqlParserGlobal.getExecutorService(), null);
    }
}

