/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.toolkit.sql;

import com.baomidou.mybatisplus.core.enums.SqlLike;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class SqlUtils
implements Constants {
    private static final String tp = "[\\w-,]+?";
    private static final Pattern pattern = Pattern.compile(String.format("\\{@((%s)|(%s:\\w+?)|(%s:\\w+?:\\w+?))}", "[\\w-,]+?", "[\\w-,]+?", "[\\w-,]+?"));
    private static final Map<String, String> PLACEHOLDER_CACHE = new ConcurrentHashMap<String, String>();

    public static String concatLike(Object str, SqlLike type) {
        switch (type) {
            case LEFT: {
                return "%" + str;
            }
            case RIGHT: {
                return str + "%";
            }
        }
        return "%" + str + "%";
    }

    public static List<String> findPlaceholder(String sql) {
        Matcher matcher = pattern.matcher(sql);
        ArrayList<String> list = new ArrayList<String>();
        while (matcher.find()) {
            list.add(matcher.group());
        }
        return list;
    }

    public static String replaceSqlPlaceholder(String sql, List<String> placeHolder, String escapeSymbol) {
        for (String s : placeHolder) {
            String body = CollectionUtils.computeIfAbsent(PLACEHOLDER_CACHE, s + escapeSymbol, s1 -> SqlUtils.getSelectBody(s, escapeSymbol));
            sql = sql.replace(s, body);
        }
        return sql;
    }

    public static String getSelectBody(String placeHolder, String escapeSymbol) {
        String tableName;
        String s1 = placeHolder.substring(2, placeHolder.length() - 1);
        int i1 = s1.indexOf(":");
        String alisa = null;
        String asAlisa = null;
        if (i1 < 0) {
            tableName = s1;
        } else {
            tableName = s1.substring(0, i1);
            if ((i1 = (s1 = s1.substring(i1 + 1)).indexOf(":")) < 0) {
                alisa = s1;
            } else {
                alisa = s1.substring(0, i1);
                asAlisa = s1.substring(i1 + 1);
            }
        }
        return SqlUtils.getSelectBody(tableName, alisa, asAlisa, escapeSymbol);
    }

    public static String getSelectBody(String tableName, String alisa, String asAlisa, String escapeSymbol) {
        int notSel = tableName.indexOf("-");
        List<String> notSelColl = null;
        if (notSel > 0) {
            notSelColl = Arrays.asList(tableName.substring(notSel + 1).split(","));
            tableName = tableName.substring(0, notSel);
        }
        TableInfo tableInfo = TableInfoHelper.getTableInfo(tableName);
        Assert.notNull(tableInfo, "can not find TableInfo Cache by \"%s\"", tableName);
        String s = tableInfo.chooseSelect(TableFieldInfo::isSelect, notSelColl);
        if (alisa == null) {
            return s;
        }
        return SqlUtils.getNewSelectBody(s, alisa, asAlisa, escapeSymbol);
    }

    public static String getNewSelectBody(String selectBody, String alisa, String asAlisa, String escapeSymbol) {
        String[] split = selectBody.split(",");
        StringBuilder sb = new StringBuilder();
        boolean asA = asAlisa != null;
        for (String body : split) {
            String sa = alisa.concat(".");
            if (asA) {
                String property;
                String column;
                int as = body.indexOf(" AS ");
                if (as < 0) {
                    column = body;
                    property = StringUtils.getTargetColumn(body);
                } else {
                    column = body.substring(0, as);
                    property = body.substring(as + 4);
                    property = StringUtils.getTargetColumn(property);
                }
                sb.append(sa).append(column).append(" AS ").append(SqlUtils.escapeColumn(asAlisa.concat(".").concat(property), escapeSymbol));
            } else {
                sb.append(sa).append(body);
            }
            sb.append(",");
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    private static String escapeColumn(String column, String escapeSymbol) {
        return escapeSymbol.concat(column).concat(escapeSymbol);
    }
}

