/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.beat;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.client.monitor.MetricsMonitor;
import com.alibaba.nacos.client.naming.beat.BeatInfo;
import com.alibaba.nacos.client.naming.net.NamingProxy;
import com.alibaba.nacos.client.naming.utils.UtilAndComs;
import com.alibaba.nacos.client.utils.LogUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class BeatReactor {
    private ScheduledExecutorService executorService;
    private NamingProxy serverProxy;
    private boolean lightBeatEnabled = false;
    public final Map<String, BeatInfo> dom2Beat = new ConcurrentHashMap<String, BeatInfo>();

    public BeatReactor(NamingProxy serverProxy) {
        this(serverProxy, UtilAndComs.DEFAULT_CLIENT_BEAT_THREAD_COUNT);
    }

    public BeatReactor(NamingProxy serverProxy, int threadCount) {
        this.serverProxy = serverProxy;
        this.executorService = new ScheduledThreadPoolExecutor(threadCount, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setDaemon(true);
                thread.setName("com.alibaba.nacos.naming.beat.sender");
                return thread;
            }
        });
    }

    public void addBeatInfo(String serviceName, BeatInfo beatInfo) {
        LogUtils.NAMING_LOGGER.info("[BEAT] adding beat: {} to beat map.", (Object)beatInfo);
        String key = this.buildKey(serviceName, beatInfo.getIp(), beatInfo.getPort());
        BeatInfo existBeat = null;
        existBeat = this.dom2Beat.remove(key);
        if (existBeat != null) {
            existBeat.setStopped(true);
        }
        this.dom2Beat.put(key, beatInfo);
        this.executorService.schedule(new BeatTask(beatInfo), beatInfo.getPeriod(), TimeUnit.MILLISECONDS);
        MetricsMonitor.getDom2BeatSizeMonitor().set((double)this.dom2Beat.size());
    }

    public void removeBeatInfo(String serviceName, String ip, int port) {
        LogUtils.NAMING_LOGGER.info("[BEAT] removing beat: {}:{}:{} from beat map.", new Object[]{serviceName, ip, port});
        BeatInfo beatInfo = this.dom2Beat.remove(this.buildKey(serviceName, ip, port));
        if (beatInfo == null) {
            return;
        }
        beatInfo.setStopped(true);
        MetricsMonitor.getDom2BeatSizeMonitor().set((double)this.dom2Beat.size());
    }

    private String buildKey(String serviceName, String ip, int port) {
        return serviceName + "#" + ip + "#" + port;
    }

    class BeatTask
    implements Runnable {
        BeatInfo beatInfo;

        public BeatTask(BeatInfo beatInfo) {
            this.beatInfo = beatInfo;
        }

        @Override
        public void run() {
            if (this.beatInfo.isStopped()) {
                return;
            }
            long nextTime = this.beatInfo.getPeriod();
            try {
                JSONObject result = BeatReactor.this.serverProxy.sendBeat(this.beatInfo, BeatReactor.this.lightBeatEnabled);
                long interval = result.getIntValue("clientBeatInterval");
                boolean lightBeatEnabled = false;
                if (result.containsKey((Object)"lightBeatEnabled")) {
                    lightBeatEnabled = result.getBooleanValue("lightBeatEnabled");
                }
                BeatReactor.this.lightBeatEnabled = lightBeatEnabled;
                if (interval > 0L) {
                    nextTime = interval;
                }
                int code = 10200;
                if (result.containsKey((Object)"code")) {
                    code = result.getIntValue("code");
                }
                if (code == 20404) {
                    Instance instance = new Instance();
                    instance.setPort(this.beatInfo.getPort());
                    instance.setIp(this.beatInfo.getIp());
                    instance.setWeight(this.beatInfo.getWeight());
                    instance.setMetadata(this.beatInfo.getMetadata());
                    instance.setClusterName(this.beatInfo.getCluster());
                    instance.setServiceName(this.beatInfo.getServiceName());
                    instance.setInstanceId(instance.getInstanceId());
                    instance.setEphemeral(true);
                    try {
                        BeatReactor.this.serverProxy.registerService(this.beatInfo.getServiceName(), NamingUtils.getGroupName((String)this.beatInfo.getServiceName()), instance);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (NacosException ne) {
                LogUtils.NAMING_LOGGER.error("[CLIENT-BEAT] failed to send beat: {}, code: {}, msg: {}", new Object[]{JSON.toJSONString((Object)this.beatInfo), ne.getErrCode(), ne.getErrMsg()});
            }
            BeatReactor.this.executorService.schedule(new BeatTask(this.beatInfo), nextTime, TimeUnit.MILLISECONDS);
        }
    }
}

