/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config;

import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.config.filter.impl.ConfigFilterChainManager;
import com.alibaba.nacos.client.config.filter.impl.ConfigRequest;
import com.alibaba.nacos.client.config.filter.impl.ConfigResponse;
import com.alibaba.nacos.client.config.http.HttpAgent;
import com.alibaba.nacos.client.config.http.MetricsHttpAgent;
import com.alibaba.nacos.client.config.http.ServerHttpAgent;
import com.alibaba.nacos.client.config.impl.ClientWorker;
import com.alibaba.nacos.client.config.impl.HttpSimpleClient;
import com.alibaba.nacos.client.config.impl.LocalConfigInfoProcessor;
import com.alibaba.nacos.client.config.utils.ContentUtils;
import com.alibaba.nacos.client.config.utils.ParamUtils;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.client.utils.ParamUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class NacosConfigService
implements ConfigService {
    private static final Logger LOGGER = LogUtils.logger(NacosConfigService.class);
    private static final long POST_TIMEOUT = 3000L;
    private static final String EMPTY = "";
    private HttpAgent agent;
    private ClientWorker worker;
    private String namespace;
    private String encode;
    private ConfigFilterChainManager configFilterChainManager = new ConfigFilterChainManager();

    public NacosConfigService(Properties properties) throws NacosException {
        String encodeTmp = properties.getProperty("encode");
        this.encode = StringUtils.isBlank((CharSequence)encodeTmp) ? "UTF-8" : encodeTmp.trim();
        this.initNamespace(properties);
        this.agent = new MetricsHttpAgent(new ServerHttpAgent(properties));
        this.agent.start();
        this.worker = new ClientWorker(this.agent, this.configFilterChainManager, properties);
    }

    private void initNamespace(Properties properties) {
        this.namespace = ParamUtil.parseNamespace(properties);
        properties.put("namespace", this.namespace);
    }

    public String getConfig(String dataId, String group, long timeoutMs) throws NacosException {
        return this.getConfigInner(this.namespace, dataId, group, timeoutMs);
    }

    public String getConfigAndSignListener(String dataId, String group, long timeoutMs, Listener listener) throws NacosException {
        String content = this.getConfig(dataId, group, timeoutMs);
        this.worker.addTenantListenersWithContent(dataId, group, content, Arrays.asList(listener));
        return content;
    }

    public void addListener(String dataId, String group, Listener listener) throws NacosException {
        this.worker.addTenantListeners(dataId, group, Arrays.asList(listener));
    }

    public boolean publishConfig(String dataId, String group, String content) throws NacosException {
        return this.publishConfigInner(this.namespace, dataId, group, null, null, null, content);
    }

    public boolean removeConfig(String dataId, String group) throws NacosException {
        return this.removeConfigInner(this.namespace, dataId, group, null);
    }

    public void removeListener(String dataId, String group, Listener listener) {
        this.worker.removeTenantListener(dataId, group, listener);
    }

    private String getConfigInner(String tenant, String dataId, String group, long timeoutMs) throws NacosException {
        group = this.null2defaultGroup(group);
        ParamUtils.checkKeyParam(dataId, group);
        ConfigResponse cr = new ConfigResponse();
        cr.setDataId(dataId);
        cr.setTenant(tenant);
        cr.setGroup(group);
        String content = LocalConfigInfoProcessor.getFailover(this.agent.getName(), dataId, group, tenant);
        if (content != null) {
            LOGGER.warn("[{}] [get-config] get failover ok, dataId={}, group={}, tenant={}, config={}", new Object[]{this.agent.getName(), dataId, group, tenant, ContentUtils.truncateContent(content)});
            cr.setContent(content);
            this.configFilterChainManager.doFilter(null, cr);
            content = cr.getContent();
            return content;
        }
        try {
            String[] ct = this.worker.getServerConfig(dataId, group, tenant, timeoutMs);
            cr.setContent(ct[0]);
            this.configFilterChainManager.doFilter(null, cr);
            content = cr.getContent();
            return content;
        }
        catch (NacosException ioe) {
            if (403 == ioe.getErrCode()) {
                throw ioe;
            }
            LOGGER.warn("[{}] [get-config] get from server error, dataId={}, group={}, tenant={}, msg={}", new Object[]{this.agent.getName(), dataId, group, tenant, ioe.toString()});
            LOGGER.warn("[{}] [get-config] get snapshot ok, dataId={}, group={}, tenant={}, config={}", new Object[]{this.agent.getName(), dataId, group, tenant, ContentUtils.truncateContent(content)});
            content = LocalConfigInfoProcessor.getSnapshot(this.agent.getName(), dataId, group, tenant);
            cr.setContent(content);
            this.configFilterChainManager.doFilter(null, cr);
            content = cr.getContent();
            return content;
        }
    }

    private String null2defaultGroup(String group) {
        return null == group ? "DEFAULT_GROUP" : group.trim();
    }

    private boolean removeConfigInner(String tenant, String dataId, String group, String tag) throws NacosException {
        group = this.null2defaultGroup(group);
        ParamUtils.checkKeyParam(dataId, group);
        String url = "/v1/cs/configs";
        ArrayList<String> params = new ArrayList<String>();
        params.add("dataId");
        params.add(dataId);
        params.add("group");
        params.add(group);
        if (StringUtils.isNotEmpty((CharSequence)tenant)) {
            params.add("tenant");
            params.add(tenant);
        }
        if (StringUtils.isNotEmpty((CharSequence)tag)) {
            params.add("tag");
            params.add(tag);
        }
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpDelete(url, null, params, this.encode, 3000L);
        }
        catch (IOException ioe) {
            LOGGER.warn("[remove] error, " + dataId + ", " + group + ", " + tenant + ", msg: " + ioe.toString());
            return false;
        }
        if (200 == result.code) {
            LOGGER.info("[{}] [remove] ok, dataId={}, group={}, tenant={}", new Object[]{this.agent.getName(), dataId, group, tenant});
            return true;
        }
        if (403 == result.code) {
            LOGGER.warn("[{}] [remove] error, dataId={}, group={}, tenant={}, code={}, msg={}", new Object[]{this.agent.getName(), dataId, group, tenant, result.code, result.content});
            throw new NacosException(result.code, result.content);
        }
        LOGGER.warn("[{}] [remove] error, dataId={}, group={}, tenant={}, code={}, msg={}", new Object[]{this.agent.getName(), dataId, group, tenant, result.code, result.content});
        return false;
    }

    private boolean publishConfigInner(String tenant, String dataId, String group, String tag, String appName, String betaIps, String content) throws NacosException {
        group = this.null2defaultGroup(group);
        ParamUtils.checkParam(dataId, group, content);
        ConfigRequest cr = new ConfigRequest();
        cr.setDataId(dataId);
        cr.setTenant(tenant);
        cr.setGroup(group);
        cr.setContent(content);
        this.configFilterChainManager.doFilter(cr, null);
        content = cr.getContent();
        String url = "/v1/cs/configs";
        ArrayList<String> params = new ArrayList<String>();
        params.add("dataId");
        params.add(dataId);
        params.add("group");
        params.add(group);
        params.add("content");
        params.add(content);
        if (StringUtils.isNotEmpty((CharSequence)tenant)) {
            params.add("tenant");
            params.add(tenant);
        }
        if (StringUtils.isNotEmpty((CharSequence)appName)) {
            params.add("appName");
            params.add(appName);
        }
        if (StringUtils.isNotEmpty((CharSequence)tag)) {
            params.add("tag");
            params.add(tag);
        }
        ArrayList<String> headers = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)betaIps)) {
            headers.add("betaIps");
            headers.add(betaIps);
        }
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpPost(url, headers, params, this.encode, 3000L);
        }
        catch (IOException ioe) {
            LOGGER.warn("[{}] [publish-single] exception, dataId={}, group={}, msg={}", new Object[]{this.agent.getName(), dataId, group, ioe.toString()});
            return false;
        }
        if (200 == result.code) {
            LOGGER.info("[{}] [publish-single] ok, dataId={}, group={}, tenant={}, config={}", new Object[]{this.agent.getName(), dataId, group, tenant, ContentUtils.truncateContent(content)});
            return true;
        }
        if (403 == result.code) {
            LOGGER.warn("[{}] [publish-single] error, dataId={}, group={}, tenant={}, code={}, msg={}", new Object[]{this.agent.getName(), dataId, group, tenant, result.code, result.content});
            throw new NacosException(result.code, result.content);
        }
        LOGGER.warn("[{}] [publish-single] error, dataId={}, group={}, tenant={}, code={}, msg={}", new Object[]{this.agent.getName(), dataId, group, tenant, result.code, result.content});
        return false;
    }

    public String getServerStatus() {
        if (this.worker.isHealthServer()) {
            return "UP";
        }
        return "DOWN";
    }
}

