/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.clickhouse.visitor;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLStructDataType;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.dialect.clickhouse.visitor.ClickhouseVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;

public class ClickhouseOutputVisitor
extends SQLASTOutputVisitor
implements ClickhouseVisitor {
    public ClickhouseOutputVisitor(Appendable appender) {
        super(appender);
    }

    public ClickhouseOutputVisitor(Appendable appender, DbType dbType) {
        super(appender, dbType);
    }

    public ClickhouseOutputVisitor(Appendable appender, boolean parameterized) {
        super(appender, parameterized);
    }

    @Override
    public boolean visit(SQLWithSubqueryClause.Entry x) {
        if (x.getExpr() != null) {
            x.getExpr().accept(this);
        } else if (x.getSubQuery() != null) {
            this.print('(');
            this.println();
            SQLSelect query = x.getSubQuery();
            if (query != null) {
                query.accept(this);
            } else {
                x.getReturningStatement().accept(this);
            }
            this.println();
            this.print(')');
        }
        this.print(' ');
        this.print0(this.ucase ? "AS " : "as ");
        this.print0(x.getAlias());
        return false;
    }

    @Override
    public boolean visit(SQLStructDataType x) {
        this.print0(this.ucase ? "NESTED (" : "nested (");
        this.incrementIndent();
        this.println();
        this.printlnAndAccept(x.getFields(), ",");
        this.decrementIndent();
        this.println();
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLStructDataType.Field x) {
        SQLDataType dataType;
        SQLName name = x.getName();
        if (name != null) {
            name.accept(this);
        }
        if ((dataType = x.getDataType()) != null) {
            this.print(' ');
            dataType.accept(this);
        }
        return false;
    }
}

