/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.postgresql.visitor;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGTypeCastExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGAlterSchemaStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGConnectToStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGCreateSchemaStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGDeleteStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGDropSchemaStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGInsertStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGSelectStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGShowStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGStartTransactionStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGUpdateStatement;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGASTVisitor;
import com.alibaba.druid.sql.repository.SchemaRepository;
import com.alibaba.druid.sql.repository.SchemaResolveVisitor;
import com.alibaba.druid.sql.visitor.SchemaStatVisitor;
import com.alibaba.druid.stat.TableStat;
import com.alibaba.druid.util.PGUtils;

public class PGSchemaStatVisitor
extends SchemaStatVisitor
implements PGASTVisitor {
    public PGSchemaStatVisitor() {
        super(DbType.postgresql);
    }

    public PGSchemaStatVisitor(SchemaRepository repository) {
        super(repository);
    }

    @Override
    public DbType getDbType() {
        return DbType.postgresql;
    }

    @Override
    public boolean visit(PGDeleteStatement x) {
        SQLTableSource using;
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        if (x.getWith() != null) {
            x.getWith().accept(this);
        }
        if ((using = x.getUsing()) != null) {
            using.accept(this);
        }
        x.putAttribute("_original_use_mode", (Object)this.getMode());
        this.setMode(x, TableStat.Mode.Delete);
        TableStat stat = this.getTableStat(x.getTableName());
        stat.incrementDeleteCount();
        this.accept(x.getWhere());
        return false;
    }

    @Override
    public boolean visit(PGInsertStatement x) {
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        if (x.getWith() != null) {
            x.getWith().accept(this);
        }
        x.putAttribute("_original_use_mode", (Object)this.getMode());
        this.setMode(x, TableStat.Mode.Insert);
        SQLName tableName = x.getTableName();
        TableStat stat = this.getTableStat(tableName);
        stat.incrementInsertCount();
        this.accept(x.getColumns());
        this.accept(x.getQuery());
        return false;
    }

    @Override
    public void endVisit(PGSelectStatement x) {
    }

    @Override
    public boolean visit(PGSelectStatement x) {
        return this.visit((SQLSelectStatement)x);
    }

    @Override
    public void endVisit(PGUpdateStatement x) {
    }

    @Override
    public boolean isPseudoColumn(long hash) {
        return PGUtils.isPseudoColumn(hash);
    }

    @Override
    public boolean visit(PGUpdateStatement x) {
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        if (x.getWith() != null) {
            x.getWith().accept(this);
        }
        TableStat stat = this.getTableStat(x.getTableName());
        stat.incrementUpdateCount();
        this.accept(x.getFrom());
        this.accept(x.getItems());
        this.accept(x.getWhere());
        return false;
    }

    @Override
    public boolean visit(PGTypeCastExpr x) {
        x.getExpr().accept(this);
        return false;
    }

    @Override
    public boolean visit(PGShowStatement x) {
        return false;
    }

    @Override
    public boolean visit(PGStartTransactionStatement x) {
        return false;
    }

    @Override
    public boolean visit(PGConnectToStatement x) {
        return false;
    }

    @Override
    public boolean visit(PGCreateSchemaStatement x) {
        return false;
    }

    @Override
    public boolean visit(PGDropSchemaStatement x) {
        return false;
    }

    @Override
    public boolean visit(PGAlterSchemaStatement x) {
        return false;
    }
}

