/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security.query_api_keys;

import co.elastic.clients.elasticsearch._types.aggregations.CardinalityAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.DateRangeAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.MissingAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.RangeAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.TermsAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.ValueCountAggregation;
import co.elastic.clients.elasticsearch.security.query_api_keys.ApiKeyAggregationVariant;
import co.elastic.clients.elasticsearch.security.query_api_keys.ApiKeyFiltersAggregation;
import co.elastic.clients.elasticsearch.security.query_api_keys.ApiKeyQuery;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.OpenTaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ApiKeyAggregation
implements OpenTaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    private final Map<String, ApiKeyAggregation> aggregations;
    private final Map<String, JsonData> meta;
    @Nullable
    private final String _customKind;
    public static final JsonpDeserializer<ApiKeyAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ApiKeyAggregation::setupApiKeyAggregationDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public ApiKeyAggregation(ApiKeyAggregationVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._apiKeyAggregationKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
        this._customKind = null;
        this.aggregations = null;
        this.meta = null;
    }

    private ApiKeyAggregation(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
        this._customKind = builder._customKind;
        this.aggregations = ApiTypeHelper.unmodifiable(builder.aggregations);
        this.meta = ApiTypeHelper.unmodifiable(builder.meta);
    }

    public static ApiKeyAggregation of(Function<Builder, ObjectBuilder<ApiKeyAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, ApiKeyAggregation> aggregations() {
        return this.aggregations;
    }

    public final Map<String, JsonData> meta() {
        return this.meta;
    }

    public boolean isCardinality() {
        return this._kind == Kind.Cardinality;
    }

    public CardinalityAggregation cardinality() {
        return (CardinalityAggregation)TaggedUnionUtils.get(this, Kind.Cardinality);
    }

    public boolean isComposite() {
        return this._kind == Kind.Composite;
    }

    public CompositeAggregation composite() {
        return (CompositeAggregation)TaggedUnionUtils.get(this, Kind.Composite);
    }

    public boolean isDateRange() {
        return this._kind == Kind.DateRange;
    }

    public DateRangeAggregation dateRange() {
        return (DateRangeAggregation)TaggedUnionUtils.get(this, Kind.DateRange);
    }

    public boolean isFilter() {
        return this._kind == Kind.Filter;
    }

    public ApiKeyQuery filter() {
        return (ApiKeyQuery)TaggedUnionUtils.get(this, Kind.Filter);
    }

    public boolean isFilters() {
        return this._kind == Kind.Filters;
    }

    public ApiKeyFiltersAggregation filters() {
        return (ApiKeyFiltersAggregation)TaggedUnionUtils.get(this, Kind.Filters);
    }

    public boolean isMissing() {
        return this._kind == Kind.Missing;
    }

    public MissingAggregation missing() {
        return (MissingAggregation)TaggedUnionUtils.get(this, Kind.Missing);
    }

    public boolean isRange() {
        return this._kind == Kind.Range;
    }

    public RangeAggregation range() {
        return (RangeAggregation)TaggedUnionUtils.get(this, Kind.Range);
    }

    public boolean isTerms() {
        return this._kind == Kind.Terms;
    }

    public TermsAggregation terms() {
        return (TermsAggregation)TaggedUnionUtils.get(this, Kind.Terms);
    }

    public boolean isValueCount() {
        return this._kind == Kind.ValueCount;
    }

    public ValueCountAggregation valueCount() {
        return (ValueCountAggregation)TaggedUnionUtils.get(this, Kind.ValueCount);
    }

    public boolean _isCustom() {
        return this._kind == Kind._Custom;
    }

    @Override
    @Nullable
    public final String _customKind() {
        return this._customKind;
    }

    public JsonData _custom() {
        return (JsonData)TaggedUnionUtils.get(this, Kind._Custom);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        if (ApiTypeHelper.isDefined(this.aggregations)) {
            generator.writeKey("aggregations");
            generator.writeStartObject();
            for (Map.Entry<String, ApiKeyAggregation> entry : this.aggregations.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("meta");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.meta.entrySet()) {
                generator.writeKey(entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey(this._kind == Kind._Custom ? this._customKind : this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupApiKeyAggregationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::aggregations, JsonpDeserializer.stringMapDeserializer(_DESERIALIZER), "aggregations", "aggs");
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "meta");
        op.add(Builder::cardinality, CardinalityAggregation._DESERIALIZER, "cardinality");
        op.add(Builder::composite, CompositeAggregation._DESERIALIZER, "composite");
        op.add(Builder::dateRange, DateRangeAggregation._DESERIALIZER, "date_range");
        op.add(Builder::filter, ApiKeyQuery._DESERIALIZER, "filter");
        op.add(Builder::filters, ApiKeyFiltersAggregation._DESERIALIZER, "filters");
        op.add(Builder::missing, MissingAggregation._DESERIALIZER, "missing");
        op.add(Builder::range, RangeAggregation._DESERIALIZER, "range");
        op.add(Builder::terms, TermsAggregation._DESERIALIZER, "terms");
        op.add(Builder::valueCount, ValueCountAggregation._DESERIALIZER, "value_count");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            JsonpUtils.ensureCustomVariantsAllowed(parser, mapper);
            builder._custom((String)name, JsonData._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ApiKeyAggregation> {
        private Kind _kind;
        private Object _value;
        private String _customKind;
        @Nullable
        private Map<String, ApiKeyAggregation> aggregations;
        @Nullable
        private Map<String, JsonData> meta;

        public final Builder aggregations(Map<String, ApiKeyAggregation> map) {
            this.aggregations = Builder._mapPutAll(this.aggregations, map);
            return this;
        }

        public final Builder aggregations(String key, ApiKeyAggregation value) {
            this.aggregations = Builder._mapPut(this.aggregations, key, value);
            return this;
        }

        public final Builder aggregations(String key, Function<Builder, ObjectBuilder<ApiKeyAggregation>> fn) {
            return this.aggregations(key, fn.apply(new Builder()).build());
        }

        public final Builder meta(Map<String, JsonData> map) {
            this.meta = Builder._mapPutAll(this.meta, map);
            return this;
        }

        public final Builder meta(String key, JsonData value) {
            this.meta = Builder._mapPut(this.meta, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        public ContainerBuilder cardinality(CardinalityAggregation v) {
            this._kind = Kind.Cardinality;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder cardinality(Function<CardinalityAggregation.Builder, ObjectBuilder<CardinalityAggregation>> fn) {
            return this.cardinality(fn.apply(new CardinalityAggregation.Builder()).build());
        }

        public ContainerBuilder composite(CompositeAggregation v) {
            this._kind = Kind.Composite;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder composite(Function<CompositeAggregation.Builder, ObjectBuilder<CompositeAggregation>> fn) {
            return this.composite(fn.apply(new CompositeAggregation.Builder()).build());
        }

        public ContainerBuilder dateRange(DateRangeAggregation v) {
            this._kind = Kind.DateRange;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder dateRange(Function<DateRangeAggregation.Builder, ObjectBuilder<DateRangeAggregation>> fn) {
            return this.dateRange(fn.apply(new DateRangeAggregation.Builder()).build());
        }

        public ContainerBuilder filter(ApiKeyQuery v) {
            this._kind = Kind.Filter;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder filter(Function<ApiKeyQuery.Builder, ObjectBuilder<ApiKeyQuery>> fn) {
            return this.filter(fn.apply(new ApiKeyQuery.Builder()).build());
        }

        public ContainerBuilder filters(ApiKeyFiltersAggregation v) {
            this._kind = Kind.Filters;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder filters(Function<ApiKeyFiltersAggregation.Builder, ObjectBuilder<ApiKeyFiltersAggregation>> fn) {
            return this.filters(fn.apply(new ApiKeyFiltersAggregation.Builder()).build());
        }

        public ContainerBuilder missing(MissingAggregation v) {
            this._kind = Kind.Missing;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder missing(Function<MissingAggregation.Builder, ObjectBuilder<MissingAggregation>> fn) {
            return this.missing(fn.apply(new MissingAggregation.Builder()).build());
        }

        public ContainerBuilder range(RangeAggregation v) {
            this._kind = Kind.Range;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder range(Function<RangeAggregation.Builder, ObjectBuilder<RangeAggregation>> fn) {
            return this.range(fn.apply(new RangeAggregation.Builder()).build());
        }

        public ContainerBuilder terms(TermsAggregation v) {
            this._kind = Kind.Terms;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder terms(Function<TermsAggregation.Builder, ObjectBuilder<TermsAggregation>> fn) {
            return this.terms(fn.apply(new TermsAggregation.Builder()).build());
        }

        public ContainerBuilder valueCount(ValueCountAggregation v) {
            this._kind = Kind.ValueCount;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder valueCount(Function<ValueCountAggregation.Builder, ObjectBuilder<ValueCountAggregation>> fn) {
            return this.valueCount(fn.apply(new ValueCountAggregation.Builder()).build());
        }

        public ContainerBuilder _custom(String name, Object data) {
            this._kind = Kind._Custom;
            this._customKind = name;
            this._value = JsonData.of(data);
            return new ContainerBuilder();
        }

        @Override
        public ApiKeyAggregation build() {
            this._checkSingleUse();
            return new ApiKeyAggregation(this);
        }

        public class ContainerBuilder
        implements ObjectBuilder<ApiKeyAggregation> {
            public final ContainerBuilder aggregations(Map<String, ApiKeyAggregation> map) {
                Builder.this.aggregations = Builder._mapPutAll(Builder.this.aggregations, map);
                return this;
            }

            public final ContainerBuilder aggregations(String key, ApiKeyAggregation value) {
                Builder.this.aggregations = Builder._mapPut(Builder.this.aggregations, key, value);
                return this;
            }

            public final ContainerBuilder aggregations(String key, Function<Builder, ObjectBuilder<ApiKeyAggregation>> fn) {
                return this.aggregations(key, fn.apply(new Builder()).build());
            }

            public final ContainerBuilder meta(Map<String, JsonData> map) {
                Builder.this.meta = Builder._mapPutAll(Builder.this.meta, map);
                return this;
            }

            public final ContainerBuilder meta(String key, JsonData value) {
                Builder.this.meta = Builder._mapPut(Builder.this.meta, key, value);
                return this;
            }

            @Override
            public ApiKeyAggregation build() {
                return Builder.this.build();
            }
        }
    }

    public static enum Kind implements JsonEnum
    {
        Cardinality("cardinality"),
        Composite("composite"),
        DateRange("date_range"),
        Filter("filter"),
        Filters("filters"),
        Missing("missing"),
        Range("range"),
        Terms("terms"),
        ValueCount("value_count"),
        _Custom(null);

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

