/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.info;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class BuildInformation
implements JsonpSerializable {
    private final String date;
    private final String hash;
    public static final JsonpDeserializer<BuildInformation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BuildInformation::setupBuildInformationDeserializer);

    private BuildInformation(Builder builder) {
        this.date = ApiTypeHelper.requireNonNull(builder.date, this, "date");
        this.hash = ApiTypeHelper.requireNonNull(builder.hash, this, "hash");
    }

    public static BuildInformation of(Function<Builder, ObjectBuilder<BuildInformation>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String date() {
        return this.date;
    }

    public final String hash() {
        return this.hash;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("date");
        generator.write(this.date);
        generator.writeKey("hash");
        generator.write(this.hash);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupBuildInformationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::date, JsonpDeserializer.stringDeserializer(), "date");
        op.add(Builder::hash, JsonpDeserializer.stringDeserializer(), "hash");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<BuildInformation> {
        private String date;
        private String hash;

        public final Builder date(String value) {
            this.date = value;
            return this;
        }

        public final Builder hash(String value) {
            this.hash = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public BuildInformation build() {
            this._checkSingleUse();
            return new BuildInformation(this);
        }
    }
}

