/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.ml.AnalysisConfig;
import co.elastic.clients.elasticsearch.ml.AnalysisLimits;
import co.elastic.clients.elasticsearch.ml.DataDescription;
import co.elastic.clients.elasticsearch.ml.Datafeed;
import co.elastic.clients.elasticsearch.ml.JobBlocked;
import co.elastic.clients.elasticsearch.ml.ModelPlotConfig;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Job
implements JsonpSerializable {
    private final boolean allowLazyOpen;
    private final AnalysisConfig analysisConfig;
    @Nullable
    private final AnalysisLimits analysisLimits;
    @Nullable
    private final Time backgroundPersistInterval;
    @Nullable
    private final JobBlocked blocked;
    @Nullable
    private final Integer createTime;
    @Nullable
    private final JsonData customSettings;
    @Nullable
    private final Long dailyModelSnapshotRetentionAfterDays;
    private final DataDescription dataDescription;
    @Nullable
    private final Datafeed datafeedConfig;
    @Nullable
    private final Boolean deleting;
    @Nullable
    private final String description;
    @Nullable
    private final Integer finishedTime;
    private final List<String> groups;
    private final String jobId;
    @Nullable
    private final String jobType;
    @Nullable
    private final String jobVersion;
    @Nullable
    private final ModelPlotConfig modelPlotConfig;
    @Nullable
    private final String modelSnapshotId;
    private final long modelSnapshotRetentionDays;
    @Nullable
    private final Long renormalizationWindowDays;
    private final String resultsIndexName;
    @Nullable
    private final Long resultsRetentionDays;
    public static final JsonpDeserializer<Job> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Job::setupJobDeserializer);

    private Job(Builder builder) {
        this.allowLazyOpen = ApiTypeHelper.requireNonNull(builder.allowLazyOpen, this, "allowLazyOpen");
        this.analysisConfig = ApiTypeHelper.requireNonNull(builder.analysisConfig, this, "analysisConfig");
        this.analysisLimits = builder.analysisLimits;
        this.backgroundPersistInterval = builder.backgroundPersistInterval;
        this.blocked = builder.blocked;
        this.createTime = builder.createTime;
        this.customSettings = builder.customSettings;
        this.dailyModelSnapshotRetentionAfterDays = builder.dailyModelSnapshotRetentionAfterDays;
        this.dataDescription = ApiTypeHelper.requireNonNull(builder.dataDescription, this, "dataDescription");
        this.datafeedConfig = builder.datafeedConfig;
        this.deleting = builder.deleting;
        this.description = builder.description;
        this.finishedTime = builder.finishedTime;
        this.groups = ApiTypeHelper.unmodifiable(builder.groups);
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.jobType = builder.jobType;
        this.jobVersion = builder.jobVersion;
        this.modelPlotConfig = builder.modelPlotConfig;
        this.modelSnapshotId = builder.modelSnapshotId;
        this.modelSnapshotRetentionDays = ApiTypeHelper.requireNonNull(builder.modelSnapshotRetentionDays, this, "modelSnapshotRetentionDays");
        this.renormalizationWindowDays = builder.renormalizationWindowDays;
        this.resultsIndexName = ApiTypeHelper.requireNonNull(builder.resultsIndexName, this, "resultsIndexName");
        this.resultsRetentionDays = builder.resultsRetentionDays;
    }

    public static Job of(Function<Builder, ObjectBuilder<Job>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean allowLazyOpen() {
        return this.allowLazyOpen;
    }

    public final AnalysisConfig analysisConfig() {
        return this.analysisConfig;
    }

    @Nullable
    public final AnalysisLimits analysisLimits() {
        return this.analysisLimits;
    }

    @Nullable
    public final Time backgroundPersistInterval() {
        return this.backgroundPersistInterval;
    }

    @Nullable
    public final JobBlocked blocked() {
        return this.blocked;
    }

    @Nullable
    public final Integer createTime() {
        return this.createTime;
    }

    @Nullable
    public final JsonData customSettings() {
        return this.customSettings;
    }

    @Nullable
    public final Long dailyModelSnapshotRetentionAfterDays() {
        return this.dailyModelSnapshotRetentionAfterDays;
    }

    public final DataDescription dataDescription() {
        return this.dataDescription;
    }

    @Nullable
    public final Datafeed datafeedConfig() {
        return this.datafeedConfig;
    }

    @Nullable
    public final Boolean deleting() {
        return this.deleting;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nullable
    public final Integer finishedTime() {
        return this.finishedTime;
    }

    public final List<String> groups() {
        return this.groups;
    }

    public final String jobId() {
        return this.jobId;
    }

    @Nullable
    public final String jobType() {
        return this.jobType;
    }

    @Nullable
    public final String jobVersion() {
        return this.jobVersion;
    }

    @Nullable
    public final ModelPlotConfig modelPlotConfig() {
        return this.modelPlotConfig;
    }

    @Nullable
    public final String modelSnapshotId() {
        return this.modelSnapshotId;
    }

    public final long modelSnapshotRetentionDays() {
        return this.modelSnapshotRetentionDays;
    }

    @Nullable
    public final Long renormalizationWindowDays() {
        return this.renormalizationWindowDays;
    }

    public final String resultsIndexName() {
        return this.resultsIndexName;
    }

    @Nullable
    public final Long resultsRetentionDays() {
        return this.resultsRetentionDays;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("allow_lazy_open");
        generator.write(this.allowLazyOpen);
        generator.writeKey("analysis_config");
        this.analysisConfig.serialize(generator, mapper);
        if (this.analysisLimits != null) {
            generator.writeKey("analysis_limits");
            this.analysisLimits.serialize(generator, mapper);
        }
        if (this.backgroundPersistInterval != null) {
            generator.writeKey("background_persist_interval");
            this.backgroundPersistInterval.serialize(generator, mapper);
        }
        if (this.blocked != null) {
            generator.writeKey("blocked");
            this.blocked.serialize(generator, mapper);
        }
        if (this.createTime != null) {
            generator.writeKey("create_time");
            generator.write(this.createTime.intValue());
        }
        if (this.customSettings != null) {
            generator.writeKey("custom_settings");
            this.customSettings.serialize(generator, mapper);
        }
        if (this.dailyModelSnapshotRetentionAfterDays != null) {
            generator.writeKey("daily_model_snapshot_retention_after_days");
            generator.write(this.dailyModelSnapshotRetentionAfterDays.longValue());
        }
        generator.writeKey("data_description");
        this.dataDescription.serialize(generator, mapper);
        if (this.datafeedConfig != null) {
            generator.writeKey("datafeed_config");
            this.datafeedConfig.serialize(generator, mapper);
        }
        if (this.deleting != null) {
            generator.writeKey("deleting");
            generator.write(this.deleting.booleanValue());
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.finishedTime != null) {
            generator.writeKey("finished_time");
            generator.write(this.finishedTime.intValue());
        }
        if (ApiTypeHelper.isDefined(this.groups)) {
            generator.writeKey("groups");
            generator.writeStartArray();
            for (String item0 : this.groups) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("job_id");
        generator.write(this.jobId);
        if (this.jobType != null) {
            generator.writeKey("job_type");
            generator.write(this.jobType);
        }
        if (this.jobVersion != null) {
            generator.writeKey("job_version");
            generator.write(this.jobVersion);
        }
        if (this.modelPlotConfig != null) {
            generator.writeKey("model_plot_config");
            this.modelPlotConfig.serialize(generator, mapper);
        }
        if (this.modelSnapshotId != null) {
            generator.writeKey("model_snapshot_id");
            generator.write(this.modelSnapshotId);
        }
        generator.writeKey("model_snapshot_retention_days");
        generator.write(this.modelSnapshotRetentionDays);
        if (this.renormalizationWindowDays != null) {
            generator.writeKey("renormalization_window_days");
            generator.write(this.renormalizationWindowDays.longValue());
        }
        generator.writeKey("results_index_name");
        generator.write(this.resultsIndexName);
        if (this.resultsRetentionDays != null) {
            generator.writeKey("results_retention_days");
            generator.write(this.resultsRetentionDays.longValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupJobDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allowLazyOpen, JsonpDeserializer.booleanDeserializer(), "allow_lazy_open");
        op.add(Builder::analysisConfig, AnalysisConfig._DESERIALIZER, "analysis_config");
        op.add(Builder::analysisLimits, AnalysisLimits._DESERIALIZER, "analysis_limits");
        op.add(Builder::backgroundPersistInterval, Time._DESERIALIZER, "background_persist_interval");
        op.add(Builder::blocked, JobBlocked._DESERIALIZER, "blocked");
        op.add(Builder::createTime, JsonpDeserializer.integerDeserializer(), "create_time");
        op.add(Builder::customSettings, JsonData._DESERIALIZER, "custom_settings");
        op.add(Builder::dailyModelSnapshotRetentionAfterDays, JsonpDeserializer.longDeserializer(), "daily_model_snapshot_retention_after_days");
        op.add(Builder::dataDescription, DataDescription._DESERIALIZER, "data_description");
        op.add(Builder::datafeedConfig, Datafeed._DESERIALIZER, "datafeed_config");
        op.add(Builder::deleting, JsonpDeserializer.booleanDeserializer(), "deleting");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::finishedTime, JsonpDeserializer.integerDeserializer(), "finished_time");
        op.add(Builder::groups, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "groups");
        op.add(Builder::jobId, JsonpDeserializer.stringDeserializer(), "job_id");
        op.add(Builder::jobType, JsonpDeserializer.stringDeserializer(), "job_type");
        op.add(Builder::jobVersion, JsonpDeserializer.stringDeserializer(), "job_version");
        op.add(Builder::modelPlotConfig, ModelPlotConfig._DESERIALIZER, "model_plot_config");
        op.add(Builder::modelSnapshotId, JsonpDeserializer.stringDeserializer(), "model_snapshot_id");
        op.add(Builder::modelSnapshotRetentionDays, JsonpDeserializer.longDeserializer(), "model_snapshot_retention_days");
        op.add(Builder::renormalizationWindowDays, JsonpDeserializer.longDeserializer(), "renormalization_window_days");
        op.add(Builder::resultsIndexName, JsonpDeserializer.stringDeserializer(), "results_index_name");
        op.add(Builder::resultsRetentionDays, JsonpDeserializer.longDeserializer(), "results_retention_days");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Job> {
        private Boolean allowLazyOpen;
        private AnalysisConfig analysisConfig;
        @Nullable
        private AnalysisLimits analysisLimits;
        @Nullable
        private Time backgroundPersistInterval;
        @Nullable
        private JobBlocked blocked;
        @Nullable
        private Integer createTime;
        @Nullable
        private JsonData customSettings;
        @Nullable
        private Long dailyModelSnapshotRetentionAfterDays;
        private DataDescription dataDescription;
        @Nullable
        private Datafeed datafeedConfig;
        @Nullable
        private Boolean deleting;
        @Nullable
        private String description;
        @Nullable
        private Integer finishedTime;
        @Nullable
        private List<String> groups;
        private String jobId;
        @Nullable
        private String jobType;
        @Nullable
        private String jobVersion;
        @Nullable
        private ModelPlotConfig modelPlotConfig;
        @Nullable
        private String modelSnapshotId;
        private Long modelSnapshotRetentionDays;
        @Nullable
        private Long renormalizationWindowDays;
        private String resultsIndexName;
        @Nullable
        private Long resultsRetentionDays;

        public final Builder allowLazyOpen(boolean value) {
            this.allowLazyOpen = value;
            return this;
        }

        public final Builder analysisConfig(AnalysisConfig value) {
            this.analysisConfig = value;
            return this;
        }

        public final Builder analysisConfig(Function<AnalysisConfig.Builder, ObjectBuilder<AnalysisConfig>> fn) {
            return this.analysisConfig(fn.apply(new AnalysisConfig.Builder()).build());
        }

        public final Builder analysisLimits(@Nullable AnalysisLimits value) {
            this.analysisLimits = value;
            return this;
        }

        public final Builder analysisLimits(Function<AnalysisLimits.Builder, ObjectBuilder<AnalysisLimits>> fn) {
            return this.analysisLimits(fn.apply(new AnalysisLimits.Builder()).build());
        }

        public final Builder backgroundPersistInterval(@Nullable Time value) {
            this.backgroundPersistInterval = value;
            return this;
        }

        public final Builder backgroundPersistInterval(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.backgroundPersistInterval(fn.apply(new Time.Builder()).build());
        }

        public final Builder blocked(@Nullable JobBlocked value) {
            this.blocked = value;
            return this;
        }

        public final Builder blocked(Function<JobBlocked.Builder, ObjectBuilder<JobBlocked>> fn) {
            return this.blocked(fn.apply(new JobBlocked.Builder()).build());
        }

        public final Builder createTime(@Nullable Integer value) {
            this.createTime = value;
            return this;
        }

        public final Builder customSettings(@Nullable JsonData value) {
            this.customSettings = value;
            return this;
        }

        public final Builder dailyModelSnapshotRetentionAfterDays(@Nullable Long value) {
            this.dailyModelSnapshotRetentionAfterDays = value;
            return this;
        }

        public final Builder dataDescription(DataDescription value) {
            this.dataDescription = value;
            return this;
        }

        public final Builder dataDescription(Function<DataDescription.Builder, ObjectBuilder<DataDescription>> fn) {
            return this.dataDescription(fn.apply(new DataDescription.Builder()).build());
        }

        public final Builder datafeedConfig(@Nullable Datafeed value) {
            this.datafeedConfig = value;
            return this;
        }

        public final Builder datafeedConfig(Function<Datafeed.Builder, ObjectBuilder<Datafeed>> fn) {
            return this.datafeedConfig(fn.apply(new Datafeed.Builder()).build());
        }

        public final Builder deleting(@Nullable Boolean value) {
            this.deleting = value;
            return this;
        }

        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public final Builder finishedTime(@Nullable Integer value) {
            this.finishedTime = value;
            return this;
        }

        public final Builder groups(List<String> list) {
            this.groups = Builder._listAddAll(this.groups, list);
            return this;
        }

        public final Builder groups(String value, String ... values) {
            this.groups = Builder._listAdd(this.groups, value, values);
            return this;
        }

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder jobType(@Nullable String value) {
            this.jobType = value;
            return this;
        }

        public final Builder jobVersion(@Nullable String value) {
            this.jobVersion = value;
            return this;
        }

        public final Builder modelPlotConfig(@Nullable ModelPlotConfig value) {
            this.modelPlotConfig = value;
            return this;
        }

        public final Builder modelPlotConfig(Function<ModelPlotConfig.Builder, ObjectBuilder<ModelPlotConfig>> fn) {
            return this.modelPlotConfig(fn.apply(new ModelPlotConfig.Builder()).build());
        }

        public final Builder modelSnapshotId(@Nullable String value) {
            this.modelSnapshotId = value;
            return this;
        }

        public final Builder modelSnapshotRetentionDays(long value) {
            this.modelSnapshotRetentionDays = value;
            return this;
        }

        public final Builder renormalizationWindowDays(@Nullable Long value) {
            this.renormalizationWindowDays = value;
            return this;
        }

        public final Builder resultsIndexName(String value) {
            this.resultsIndexName = value;
            return this;
        }

        public final Builder resultsRetentionDays(@Nullable Long value) {
            this.resultsRetentionDays = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Job build() {
            this._checkSingleUse();
            return new Job(this);
        }
    }
}

