/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.ml.DeleteForecastResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class DeleteForecastRequest
extends RequestBase {
    @Nullable
    private final Boolean allowNoForecasts;
    @Nullable
    private final String forecastId;
    private final String jobId;
    @Nullable
    private final Time timeout;
    public static final Endpoint<DeleteForecastRequest, DeleteForecastResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<DeleteForecastRequest, DeleteForecastResponse>("es/ml.delete_forecast", request -> "DELETE", request -> {
        boolean _jobId = true;
        int _forecastId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if (request.forecastId() != null) {
            propsSet |= 2;
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/_forecast");
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/_forecast");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.forecastId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoForecasts != null) {
            params.put("allow_no_forecasts", String.valueOf(request.allowNoForecasts));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, DeleteForecastResponse._DESERIALIZER);

    private DeleteForecastRequest(Builder builder) {
        this.allowNoForecasts = builder.allowNoForecasts;
        this.forecastId = builder.forecastId;
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.timeout = builder.timeout;
    }

    public static DeleteForecastRequest of(Function<Builder, ObjectBuilder<DeleteForecastRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoForecasts() {
        return this.allowNoForecasts;
    }

    @Nullable
    public final String forecastId() {
        return this.forecastId;
    }

    public final String jobId() {
        return this.jobId;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DeleteForecastRequest> {
        @Nullable
        private Boolean allowNoForecasts;
        @Nullable
        private String forecastId;
        private String jobId;
        @Nullable
        private Time timeout;

        public final Builder allowNoForecasts(@Nullable Boolean value) {
            this.allowNoForecasts = value;
            return this;
        }

        public final Builder forecastId(@Nullable String value) {
            this.forecastId = value;
            return this;
        }

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DeleteForecastRequest build() {
            this._checkSingleUse();
            return new DeleteForecastRequest(this);
        }
    }
}

