/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.license;

import co.elastic.clients.elasticsearch._types.AcknowledgedResponseBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class PostStartBasicResponse
extends AcknowledgedResponseBase {
    private final Map<String, List<String>> acknowledge;
    private final boolean basicWasStarted;
    private final String errorMessage;
    public static final JsonpDeserializer<PostStartBasicResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PostStartBasicResponse::setupPostStartBasicResponseDeserializer);

    private PostStartBasicResponse(Builder builder) {
        super(builder);
        this.acknowledge = ApiTypeHelper.unmodifiableRequired(builder.acknowledge, (Object)this, "acknowledge");
        this.basicWasStarted = ApiTypeHelper.requireNonNull(builder.basicWasStarted, this, "basicWasStarted");
        this.errorMessage = ApiTypeHelper.requireNonNull(builder.errorMessage, this, "errorMessage");
    }

    public static PostStartBasicResponse of(Function<Builder, ObjectBuilder<PostStartBasicResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, List<String>> acknowledge() {
        return this.acknowledge;
    }

    public final boolean basicWasStarted() {
        return this.basicWasStarted;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.acknowledge)) {
            generator.writeKey("acknowledge");
            generator.writeStartObject();
            for (Map.Entry<String, List<String>> item0 : this.acknowledge.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.writeStartArray();
                if (item0.getValue() != null) {
                    for (String item1 : item0.getValue()) {
                        generator.write(item1);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        generator.writeKey("basic_was_started");
        generator.write(this.basicWasStarted);
        generator.writeKey("error_message");
        generator.write(this.errorMessage);
    }

    protected static void setupPostStartBasicResponseDeserializer(ObjectDeserializer<Builder> op) {
        AcknowledgedResponseBase.setupAcknowledgedResponseBaseDeserializer(op);
        op.add(Builder::acknowledge, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer())), "acknowledge");
        op.add(Builder::basicWasStarted, JsonpDeserializer.booleanDeserializer(), "basic_was_started");
        op.add(Builder::errorMessage, JsonpDeserializer.stringDeserializer(), "error_message");
    }

    public static class Builder
    extends AcknowledgedResponseBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PostStartBasicResponse> {
        private Map<String, List<String>> acknowledge;
        private Boolean basicWasStarted;
        private String errorMessage;

        public final Builder acknowledge(Map<String, List<String>> map) {
            this.acknowledge = Builder._mapPutAll(this.acknowledge, map);
            return this;
        }

        public final Builder acknowledge(String key, List<String> value) {
            this.acknowledge = Builder._mapPut(this.acknowledge, key, value);
            return this;
        }

        public final Builder basicWasStarted(boolean value) {
            this.basicWasStarted = value;
            return this;
        }

        public final Builder errorMessage(String value) {
            this.errorMessage = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PostStartBasicResponse build() {
            this._checkSingleUse();
            return new PostStartBasicResponse(this);
        }
    }
}

