/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.core.MgetResponse;
import co.elastic.clients.elasticsearch.core.mget.MultiGetOperation;
import co.elastic.clients.elasticsearch.core.search.SourceConfigParam;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public class MgetRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final SourceConfigParam source;
    private final List<String> sourceExcludes;
    private final List<String> sourceIncludes;
    private final List<MultiGetOperation> docs;
    private final List<String> ids;
    @Nullable
    private final String index;
    @Nullable
    private final String preference;
    @Nullable
    private final Boolean realtime;
    @Nullable
    private final Boolean refresh;
    @Nullable
    private final String routing;
    private final List<String> storedFields;
    @Nullable
    private final String type;
    public static final JsonpDeserializer<MgetRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MgetRequest::setupMgetRequestDeserializer);
    public static final SimpleEndpoint<MgetRequest, ?> _ENDPOINT = new SimpleEndpoint<MgetRequest, MgetResponse<Object>>("es/mget", request -> "POST", request -> {
        boolean _index = true;
        int _type = 2;
        int propsSet = 0;
        if (request.index() != null) {
            propsSet |= 1;
        }
        if (request.type() != null) {
            propsSet |= 2;
        }
        if (propsSet == 0) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_mget");
            return buf.toString();
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_mget");
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type, buf);
            buf.append("/_mget");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.routing != null) {
            params.put("routing", request.routing);
        }
        if (request.realtime != null) {
            params.put("realtime", String.valueOf(request.realtime));
        }
        if (ApiTypeHelper.isDefined(request.storedFields)) {
            params.put("stored_fields", request.storedFields.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.preference != null) {
            params.put("preference", request.preference);
        }
        if (request.refresh != null) {
            params.put("refresh", String.valueOf(request.refresh));
        }
        if (request.source != null) {
            params.put("_source", request.source._toJsonString());
        }
        if (ApiTypeHelper.isDefined(request.sourceExcludes)) {
            params.put("_source_excludes", request.sourceExcludes.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (ApiTypeHelper.isDefined(request.sourceIncludes)) {
            params.put("_source_includes", request.sourceIncludes.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, MgetResponse._DESERIALIZER);

    private MgetRequest(Builder builder) {
        this.source = builder.source;
        this.sourceExcludes = ApiTypeHelper.unmodifiable(builder.sourceExcludes);
        this.sourceIncludes = ApiTypeHelper.unmodifiable(builder.sourceIncludes);
        this.docs = ApiTypeHelper.unmodifiable(builder.docs);
        this.ids = ApiTypeHelper.unmodifiable(builder.ids);
        this.index = builder.index;
        this.preference = builder.preference;
        this.realtime = builder.realtime;
        this.refresh = builder.refresh;
        this.routing = builder.routing;
        this.storedFields = ApiTypeHelper.unmodifiable(builder.storedFields);
        this.type = builder.type;
    }

    public static MgetRequest of(Function<Builder, ObjectBuilder<MgetRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final SourceConfigParam source() {
        return this.source;
    }

    public final List<String> sourceExcludes() {
        return this.sourceExcludes;
    }

    public final List<String> sourceIncludes() {
        return this.sourceIncludes;
    }

    public final List<MultiGetOperation> docs() {
        return this.docs;
    }

    public final List<String> ids() {
        return this.ids;
    }

    @Nullable
    public final String index() {
        return this.index;
    }

    @Nullable
    public final String preference() {
        return this.preference;
    }

    @Nullable
    public final Boolean realtime() {
        return this.realtime;
    }

    @Nullable
    public final Boolean refresh() {
        return this.refresh;
    }

    @Nullable
    public final String routing() {
        return this.routing;
    }

    public final List<String> storedFields() {
        return this.storedFields;
    }

    @Nullable
    public final String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.docs)) {
            generator.writeKey("docs");
            generator.writeStartArray();
            for (MultiGetOperation multiGetOperation : this.docs) {
                multiGetOperation.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.ids)) {
            generator.writeKey("ids");
            generator.writeStartArray();
            for (String string : this.ids) {
                generator.write(string);
            }
            generator.writeEnd();
        }
    }

    protected static void setupMgetRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::docs, JsonpDeserializer.arrayDeserializer(MultiGetOperation._DESERIALIZER), "docs");
        op.add(Builder::ids, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "ids");
    }

    public static <TDocument> Endpoint<MgetRequest, MgetResponse<TDocument>, ErrorResponse> createMgetEndpoint(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return _ENDPOINT.withResponseDeserializer(MgetResponse.createMgetResponseDeserializer(tDocumentDeserializer));
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<MgetRequest> {
        @Nullable
        private SourceConfigParam source;
        @Nullable
        private List<String> sourceExcludes;
        @Nullable
        private List<String> sourceIncludes;
        @Nullable
        private List<MultiGetOperation> docs;
        @Nullable
        private List<String> ids;
        @Nullable
        private String index;
        @Nullable
        private String preference;
        @Nullable
        private Boolean realtime;
        @Nullable
        private Boolean refresh;
        @Nullable
        private String routing;
        @Nullable
        private List<String> storedFields;
        @Nullable
        private String type;

        public final Builder source(@Nullable SourceConfigParam value) {
            this.source = value;
            return this;
        }

        public final Builder source(Function<SourceConfigParam.Builder, ObjectBuilder<SourceConfigParam>> fn) {
            return this.source(fn.apply(new SourceConfigParam.Builder()).build());
        }

        public final Builder sourceExcludes(List<String> list) {
            this.sourceExcludes = Builder._listAddAll(this.sourceExcludes, list);
            return this;
        }

        public final Builder sourceExcludes(String value, String ... values) {
            this.sourceExcludes = Builder._listAdd(this.sourceExcludes, value, values);
            return this;
        }

        public final Builder sourceIncludes(List<String> list) {
            this.sourceIncludes = Builder._listAddAll(this.sourceIncludes, list);
            return this;
        }

        public final Builder sourceIncludes(String value, String ... values) {
            this.sourceIncludes = Builder._listAdd(this.sourceIncludes, value, values);
            return this;
        }

        public final Builder docs(List<MultiGetOperation> list) {
            this.docs = Builder._listAddAll(this.docs, list);
            return this;
        }

        public final Builder docs(MultiGetOperation value, MultiGetOperation ... values) {
            this.docs = Builder._listAdd(this.docs, value, values);
            return this;
        }

        public final Builder docs(Function<MultiGetOperation.Builder, ObjectBuilder<MultiGetOperation>> fn) {
            return this.docs(fn.apply(new MultiGetOperation.Builder()).build(), new MultiGetOperation[0]);
        }

        public final Builder ids(List<String> list) {
            this.ids = Builder._listAddAll(this.ids, list);
            return this;
        }

        public final Builder ids(String value, String ... values) {
            this.ids = Builder._listAdd(this.ids, value, values);
            return this;
        }

        public final Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        public final Builder preference(@Nullable String value) {
            this.preference = value;
            return this;
        }

        public final Builder realtime(@Nullable Boolean value) {
            this.realtime = value;
            return this;
        }

        public final Builder refresh(@Nullable Boolean value) {
            this.refresh = value;
            return this;
        }

        public final Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public final Builder storedFields(List<String> list) {
            this.storedFields = Builder._listAddAll(this.storedFields, list);
            return this;
        }

        public final Builder storedFields(String value, String ... values) {
            this.storedFields = Builder._listAdd(this.storedFields, value, values);
            return this;
        }

        public final Builder type(@Nullable String value) {
            this.type = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MgetRequest build() {
            this._checkSingleUse();
            return new MgetRequest(this);
        }
    }
}

