/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.AggregateVariant;
import co.elastic.clients.elasticsearch._types.aggregations.SingleMetricAggregateBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class BucketMetricValueAggregate
extends SingleMetricAggregateBase
implements AggregateVariant {
    private final List<String> keys;
    public static final JsonpDeserializer<BucketMetricValueAggregate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BucketMetricValueAggregate::setupBucketMetricValueAggregateDeserializer);

    private BucketMetricValueAggregate(Builder builder) {
        super(builder);
        this.keys = ApiTypeHelper.unmodifiableRequired(builder.keys, (Object)this, "keys");
    }

    public static BucketMetricValueAggregate of(Function<Builder, ObjectBuilder<BucketMetricValueAggregate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregate.Kind _aggregateKind() {
        return Aggregate.Kind.BucketMetricValue;
    }

    public final List<String> keys() {
        return this.keys;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.keys)) {
            generator.writeKey("keys");
            generator.writeStartArray();
            for (String item0 : this.keys) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupBucketMetricValueAggregateDeserializer(ObjectDeserializer<Builder> op) {
        SingleMetricAggregateBase.setupSingleMetricAggregateBaseDeserializer(op);
        op.add(Builder::keys, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "keys");
    }

    public static class Builder
    extends SingleMetricAggregateBase.AbstractBuilder<Builder>
    implements ObjectBuilder<BucketMetricValueAggregate> {
        private List<String> keys;

        public final Builder keys(List<String> list) {
            this.keys = Builder._listAddAll(this.keys, list);
            return this;
        }

        public final Builder keys(String value, String ... values) {
            this.keys = Builder._listAdd(this.keys, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public BucketMetricValueAggregate build() {
            this._checkSingleUse();
            return new BucketMetricValueAggregate(this);
        }
    }
}

